/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.hover;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMNamedNodeMapImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.taginfo.MarkupTagInfoProvider;
import org.tizen.web.editor.html.hover.HTMLMarkupTagInfoProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLTagAttributeInfoHoverProcessor {
    protected MarkupTagInfoProvider fInfoProvider = null;

    protected Object computeHoverHelp(ITextViewer textViewer, int documentPosition) {
        ITextRegion region;
        Object result = null;
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)documentPosition);
        if (treeNode == null) {
            return null;
        }
        Node node = (Node)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode parentNode = (IDOMNode)node;
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(documentPosition);
        if (flatNode != null && (region = flatNode.getRegionAtCharacterOffset(documentPosition)) != null) {
            result = this.computeRegionHelp(treeNode, parentNode, flatNode, region);
        }
        return result;
    }

    protected Object computeRegionHelp(IndexedRegion treeNode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        Object result = null;
        if (region == null) {
            return null;
        }
        String regionType = region.getType();
        if (regionType == "XML_TAG_NAME") {
            result = this.computeTagNameHelp((IDOMNode)treeNode, parentNode, flatNode, region);
        } else if (regionType == "XML_TAG_ATTRIBUTE_NAME") {
            result = this.computeTagAttNameHelp((IDOMNode)treeNode, parentNode, flatNode, region);
        } else if (regionType == "XML_TAG_ATTRIBUTE_VALUE") {
            result = this.computeTagAttValueHelp((IDOMNode)treeNode, parentNode, flatNode, region);
        }
        return result;
    }

    protected Object computeTagAttNameHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        CMElementDeclaration elementDecl = this.getCMElementDeclaration((Node)xmlnode);
        String attName = flatNode.getText(region);
        CMAttributeDeclaration attDecl = this.getCMAttributeDeclaration(xmlnode, elementDecl, attName);
        return this.getAdditionalInfo((CMNode)elementDecl, (CMNode)attDecl);
    }

    protected Object computeTagNameHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        CMElementDeclaration elementDecl = this.getCMElementDeclaration((Node)xmlnode);
        CMElementDeclaration pelementDecl = this.getCMElementDeclaration((Node)parentNode);
        return this.getAdditionalInfo((CMNode)pelementDecl, (CMNode)elementDecl);
    }

    protected Object getAdditionalInfo(CMNode parentOrOwner, CMNode cmnode) {
        String addlInfo = null;
        if (cmnode == null) {
            return null;
        }
        addlInfo = this.getInfoProvider().getInfo(cmnode);
        if (addlInfo == null && parentOrOwner != null) {
            addlInfo = this.getInfoProvider().getInfo(parentOrOwner);
        }
        return addlInfo;
    }

    protected ITextRegion getAttrNameRegion(IDOMNode node, ITextRegion region) {
        IStructuredDocumentRegion open = node.getFirstStructuredDocumentRegion();
        ITextRegionList openRegions = open.getRegions();
        int i = openRegions.indexOf(region);
        if (i < 0) {
            return null;
        }
        ITextRegion nameRegion = null;
        while (i >= 0) {
            if ((nameRegion = openRegions.get(i--)).getType() == "XML_TAG_ATTRIBUTE_NAME") break;
        }
        return nameRegion;
    }

    protected CMAttributeDeclaration getCMAttributeDeclaration(IDOMNode node, CMElementDeclaration elementDecl, String attName) {
        CMAttributeDeclaration attrDecl = null;
        if (elementDecl != null) {
            List nodes;
            CMNamedNodeMap attributes = elementDecl.getAttributes();
            CMNamedNodeMapImpl allAttributes = new CMNamedNodeMapImpl(attributes);
            ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument());
            if (modelQuery != null && (nodes = modelQuery.getAvailableContent((Element)node, elementDecl, 1)) != null) {
                int k = 0;
                while (k < nodes.size()) {
                    CMNode cmnode = (CMNode)nodes.get(k);
                    if (cmnode.getNodeType() == 2) {
                        allAttributes.put(cmnode);
                    }
                    ++k;
                }
                attributes = allAttributes;
                String noprefixName = DOMNamespaceHelper.getUnprefixedName((String)attName);
                if (attributes != null && (attrDecl = (CMAttributeDeclaration)attributes.getNamedItem(noprefixName)) == null) {
                    attrDecl = (CMAttributeDeclaration)attributes.getNamedItem(attName);
                }
            }
        }
        return attrDecl;
    }

    protected CMElementDeclaration getCMElementDeclaration(Node node) {
        ModelQuery modelQuery;
        CMElementDeclaration result = null;
        if (node.getNodeType() == 1 && (modelQuery = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument())) != null) {
            result = modelQuery.getCMElementDeclaration((Element)node);
        }
        return result;
    }

    public Object getHoverInfo(ITextViewer viewer, IRegion hoverRegion) {
        if (hoverRegion == null || viewer == null || viewer.getDocument() == null) {
            return null;
        }
        Object displayText = null;
        int documentOffset = hoverRegion.getOffset();
        displayText = this.computeHoverHelp(viewer, documentOffset);
        return displayText;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        String regionType;
        if (textViewer == null || textViewer.getDocument() == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(offset);
        ITextRegion region = null;
        if (flatNode != null) {
            region = flatNode.getRegionAtCharacterOffset(offset);
        }
        if (region != null && ((regionType = region.getType()) == "XML_TAG_NAME" || regionType == "XML_TAG_ATTRIBUTE_NAME" || regionType == "XML_TAG_ATTRIBUTE_VALUE")) {
            try {
                IRegion line = textViewer.getDocument().getLineInformationOfOffset(offset);
                if (offset > line.getOffset() && offset < line.getOffset() + line.getLength() && offset < flatNode.getTextEndOffset(region)) {
                    return new Region(flatNode.getStartOffset(region), region.getTextLength());
                }
            }
            catch (BadLocationException e) {
                Logger.logException((Throwable)e);
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset, boolean enabled) {
        String regionType;
        if (!enabled || textViewer == null || textViewer.getDocument() == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(offset);
        ITextRegion region = null;
        if (flatNode != null) {
            region = flatNode.getRegionAtCharacterOffset(offset);
        }
        if (region != null && ((regionType = region.getType()) == "XML_TAG_NAME" || regionType == "XML_TAG_ATTRIBUTE_NAME" || regionType == "XML_TAG_ATTRIBUTE_VALUE")) {
            try {
                IRegion line = textViewer.getDocument().getLineInformationOfOffset(offset);
                if (offset > line.getOffset() && offset < line.getOffset() + line.getLength() && offset < flatNode.getTextEndOffset(region)) {
                    return new Region(flatNode.getStartOffset(region), region.getTextLength());
                }
            }
            catch (BadLocationException e) {
                Logger.logException((Throwable)e);
            }
        }
        return null;
    }

    protected Object computeTagAttValueHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        CMElementDeclaration elementDecl = this.getCMElementDeclaration((Node)xmlnode);
        ITextRegion attrValueRegion = this.getAttrValueRegion(xmlnode, region);
        String attValue = flatNode.getText(attrValueRegion);
        ITextRegion attrNameRegion = this.getAttrNameRegion(xmlnode, region);
        String attName = flatNode.getText(attrNameRegion);
        CMAttributeDeclaration attDecl = this.getCMAttributeDeclaration(xmlnode, elementDecl, attName);
        return this.getAdditionalInfo(xmlnode, flatNode, (CMNode)elementDecl, (CMNode)attDecl, attName, attValue);
    }

    protected ITextRegion getAttrValueRegion(IDOMNode node, ITextRegion region) {
        IStructuredDocumentRegion open = node.getFirstStructuredDocumentRegion();
        ITextRegionList openRegions = open.getRegions();
        int i = openRegions.indexOf(region);
        if (i < 0) {
            return null;
        }
        ITextRegion nameRegion = null;
        while (i >= 0) {
            if ((nameRegion = openRegions.get(i--)).getType() == "XML_TAG_ATTRIBUTE_VALUE") break;
        }
        return nameRegion;
    }

    protected Object getAdditionalInfo(IDOMNode xmlnode, IStructuredDocumentRegion flatNode, CMNode parentOrOwner, CMNode cmnode, String attName, String attrValue) {
        Object addlInfo = null;
        if (cmnode == null) {
            return null;
        }
        addlInfo = ((HTMLMarkupTagInfoProvider)this.getInfoProvider()).getInfo(xmlnode, flatNode, parentOrOwner, cmnode, attName, attrValue);
        if (addlInfo == null && parentOrOwner != null) {
            addlInfo = this.getInfoProvider().getInfo(parentOrOwner);
        }
        return addlInfo;
    }

    public MarkupTagInfoProvider getInfoProvider() {
        if (this.fInfoProvider == null) {
            this.fInfoProvider = new HTMLMarkupTagInfoProvider();
        }
        return this.fInfoProvider;
    }
}

