/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.refactoring.extraction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.web.editor.html.HTMLAdvancedFeatureConstants;
import org.tizen.web.editor.html.refactoring.extraction.ScriptCodeExtractorDialogResult;
import org.tizen.web.editor.html.refactoring.extraction.ScriptCodeExtractorNameInputDialog;

public class ScriptCodeExtractorDialog
extends ElementTreeSelectionDialog
implements HTMLAdvancedFeatureConstants {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Image informationImage = null;
    private String newResourceName = null;
    private IResource createdResource = null;

    public ScriptCodeExtractorDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createInformaitonArea(composite);
        this.getTreeViewer().expandAll();
        Tree tree = this.getTreeViewer().getTree();
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Widget item = e.item;
                if (item instanceof TreeItem) {
                    Object data = ((TreeItem)item).getData();
                    if (data instanceof IFile) {
                        Button okButton = ScriptCodeExtractorDialog.this.getOkButton();
                        if (okButton != null) {
                            okButton.setEnabled(true);
                        }
                    } else {
                        Button okButton = ScriptCodeExtractorDialog.this.getOkButton();
                        if (okButton != null) {
                            okButton.setEnabled(false);
                        }
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Menu menu = new Menu((Control)tree);
        tree.setMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                ISelection selection = ScriptCodeExtractorDialog.this.getTreeViewer().getSelection();
                IResource selectedResource = null;
                if (selection != null && selection instanceof TreeSelection && (selectedResource = (IResource)((TreeSelection)selection).getFirstElement()) != null && selectedResource instanceof IFile) {
                    return;
                }
                final IResource parentResource = selectedResource;
                MenuItem newFolderItem = new MenuItem(menu, 0);
                newFolderItem.setText("Create a new folder");
                newFolderItem.setImage(folderImage);
                newFolderItem.setData("SELECTED_RESOURCE", (Object)selectedResource);
                newFolderItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ScriptCodeExtractorDialog.this.newResourceName = ScriptCodeExtractorDialog.this.getNameFromInputDialog("NEW FOLDER", "Enter the folder name to be created.", "", true, parentResource);
                        if (ScriptCodeExtractorDialog.this.newResourceName != null && !ScriptCodeExtractorDialog.this.newResourceName.trim().equals("")) {
                            MenuItem selectedMenuItem = (MenuItem)e.widget;
                            ScriptCodeExtractorDialog.this.makeNewResource(selectedMenuItem, true);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                MenuItem newFileItem = new MenuItem(menu, 0);
                newFileItem.setText("Create a new file");
                newFileItem.setImage(jsFileImage);
                newFileItem.setData("SELECTED_RESOURCE", (Object)selectedResource);
                newFileItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ScriptCodeExtractorDialog.this.newResourceName = ScriptCodeExtractorDialog.this.getNameFromInputDialog("NEW FILE", "Enter the file name to be created.", "", false, parentResource);
                        if (ScriptCodeExtractorDialog.this.newResourceName != null && !ScriptCodeExtractorDialog.this.newResourceName.trim().equals("")) {
                            MenuItem selectedMenuItem = (MenuItem)e.widget;
                            ScriptCodeExtractorDialog.this.makeNewResource(selectedMenuItem, false);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
        });
        return composite;
    }

    protected void computeResult() {
        Object firstElement;
        ISelection selection = this.getTreeViewer().getSelection();
        if (selection != null && selection instanceof TreeSelection && (firstElement = ((TreeSelection)selection).getFirstElement()) != null && firstElement instanceof IFile) {
            IProject project = ((IFile)firstElement).getProject();
            String parentPath = ((IFile)firstElement).getParent().getFullPath().toString();
            parentPath = parentPath.substring(project.getName().length() + 1);
            String fileName = ((IFile)firstElement).getName();
            ScriptCodeExtractorDialogResult result = new ScriptCodeExtractorDialogResult((IResource)firstElement, parentPath, fileName);
            ArrayList<ScriptCodeExtractorDialogResult> resultList = new ArrayList<ScriptCodeExtractorDialogResult>();
            resultList.add(result);
            this.setResult(resultList);
        }
    }

    protected void okPressed() {
        this.computeResult();
        if (this.validateResult()) {
            this.setReturnCode(0);
        }
        this.close();
    }

    public boolean close() {
        if (this.informationImage != null) {
            this.informationImage.dispose();
        }
        return super.close();
    }

    private boolean validateResult() {
        Object firstElement;
        boolean isValid = false;
        ISelection selection = this.getTreeViewer().getSelection();
        if (selection != null && selection instanceof TreeSelection && (firstElement = ((TreeSelection)selection).getFirstElement()) != null && firstElement instanceof IFile) {
            isValid = true;
        }
        return isValid;
    }

    private void createInformaitonArea(Composite composite) {
        Composite informationContainer = new Composite(composite, 0);
        informationContainer.setLayout((Layout)new RowLayout(256));
        this.informationImage = this.getShell().getDisplay().getSystemImage(2);
        this.informationImage = this.resize(this.informationImage, 16, 16);
        Label informationLabel = new Label(informationContainer, 0);
        informationLabel.setBackground(composite.getBackground());
        informationLabel.setImage(this.informationImage);
        informationLabel.setSize(16, 16);
        Text informationText = new Text(informationContainer, 2);
        informationText.setText("If you want to create a new file or folder, select mouse right-click at parent node.");
        informationText.setBackground(composite.getBackground());
    }

    private Image resize(Image image, int width, int height) {
        Image scaled = new Image((Device)Display.getDefault(), width, height);
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, width, height);
        gc.dispose();
        return scaled;
    }

    private String getNameFromInputDialog(String title, String message, String initValue, boolean isFolder, IResource parentResource) {
        ScriptCodeExtractorNameInputDialog inputDialog = new ScriptCodeExtractorNameInputDialog(Display.getCurrent().getActiveShell(), title, message, initValue, new FileNameValidator(), isFolder, parentResource);
        if (inputDialog.open() != 0) {
            return null;
        }
        return FilenameUtil.getEscapedName((String)inputDialog.getValue());
    }

    private void makeNewResource(MenuItem selectedMenuItem, final boolean isFolder) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        String workspacePathString = workspaceRoot.getLocation().toString();
        IResource parent = (IResource)selectedMenuItem.getData("SELECTED_RESOURCE");
        String newFolderPath = String.valueOf(workspacePathString) + parent.getFullPath().toOSString() + "/" + this.newResourceName;
        File resource = new File(newFolderPath);
        if (!resource.exists()) {
            if (isFolder) {
                resource.mkdir();
            } else {
                try {
                    resource.createNewFile();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        try {
            Object firstElement;
            parent.refreshLocal(2, null);
            this.setInput(ResourcesPlugin.getWorkspace().getRoot());
            this.getTreeViewer().refresh();
            this.getTreeViewer().expandAll();
            ISelection selection = this.getTreeViewer().getSelection();
            if (selection != null && selection instanceof TreeSelection && (firstElement = ((TreeSelection)selection).getFirstElement()) != null && firstElement instanceof IResource) {
                IResource currentSelectedResource = (IResource)firstElement;
                final String currentSelectedResourcePath = currentSelectedResource.getFullPath().toString();
                currentSelectedResource.getProject().accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        String fullPath = resource.getFullPath().toString();
                        String name = resource.getName();
                        int type = resource.getType();
                        if (name != null && name.equals(ScriptCodeExtractorDialog.this.newResourceName) && fullPath != null && fullPath.contains(currentSelectedResourcePath) && (isFolder ? type == 2 : type == 1)) {
                            ScriptCodeExtractorDialog.this.createdResource = resource;
                            return false;
                        }
                        return true;
                    }
                });
            }
            if (this.createdResource != null) {
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)this.createdResource), true);
            }
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    static class FileNameValidator
    implements IInputValidator {
        FileNameValidator() {
        }

        public String isValid(String fileName) {
            int validCheck = FilenameUtil.isVaildName((String)fileName, (int)OSChecker.getOSID());
            if (validCheck != 0) {
                switch (validCheck) {
                    case 1: {
                        return "The file name contains invalid characters like " + FilenameUtil.getInvalidCharacters((int)OSChecker.getOSID());
                    }
                    case 2: {
                        return "The file name is not be empty.";
                    }
                    case 3: {
                        return "The file name is not be empty.";
                    }
                }
            }
            return null;
        }
    }
}

