/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.preference;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.tizen.web.config.schema.model.Preference;
import org.tizen.web.editor.configuration.support.AbstractChangeListener;

public class PreferenceEditingSupport
extends EditingSupport {
    private int column;
    private CellEditor editor;
    private AbstractChangeListener listener;

    public PreferenceEditingSupport(ColumnViewer viewer, int column) {
        super(viewer);
        this.column = column;
        switch (column) {
            case 0: {
                if (!(viewer instanceof TableViewer)) break;
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
            case 1: {
                if (!(viewer instanceof TableViewer)) break;
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
            case 2: {
                this.editor = new CheckboxCellEditor(null, 40);
                break;
            }
        }
    }

    protected boolean canEdit(Object element) {
        switch (this.column) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected Object getValue(Object element) {
        if (!(element instanceof Preference)) {
            return null;
        }
        Preference preference = (Preference)element;
        switch (this.column) {
            case 0: {
                return preference.getName();
            }
            case 1: {
                return preference.getValue();
            }
            case 2: {
                return Boolean.parseBoolean(preference.getReadonly());
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (!(element instanceof Preference)) {
            return;
        }
        Preference preference = (Preference)element;
        switch (this.column) {
            case 0: {
                preference.setName((String)value);
                break;
            }
            case 1: {
                preference.setValue((String)value);
                break;
            }
            case 2: {
                preference.setReadonly(((Boolean)value).toString());
                break;
            }
        }
        this.getViewer().update(element, null);
        if (this.getListener() != null) {
            this.getListener().notifyChange();
        }
    }

    public void setListener(AbstractChangeListener listener) {
        this.listener = listener;
    }

    public void unsetListener() {
        this.listener = null;
    }

    public AbstractChangeListener getListener() {
        return this.listener;
    }
}

