/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.widl.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import org.tizen.web.editor.widl.model.Interface;
import org.tizen.web.editor.widl.model.Typedef;

public class Module {
    private String name;
    private String description;
    private Hashtable<String, Typedef> typedefs;
    private Hashtable<String, Interface> interfaces;
    private Collection<String[]> implementations;
    private String featureName;
    private Collection<String> subfeatureNames;

    public Module(String name) {
        this.name = name;
        this.description = null;
        this.typedefs = new Hashtable();
        this.interfaces = new Hashtable();
        this.implementations = new HashSet<String[]>();
        this.subfeatureNames = new HashSet<String>();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addTypedef(Typedef typedef) {
        this.typedefs.put(typedef.getRestType(), typedef);
    }

    public Typedef getTypedef(String name) {
        return this.typedefs.get(name);
    }

    public void addInterface(Interface interfaze) {
        this.interfaces.put(interfaze.getName(), interfaze);
    }

    public Collection<Interface> getInterfaces() {
        return this.interfaces.values();
    }

    public void addImplementationDeclaration(String target, String source) {
        String[] input = new String[]{target, source};
        this.implementations.add(input);
    }

    public Collection<String[]> getImplementationDeclarations() {
        return this.implementations;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public void addSubfeatureName(String featureName) {
        this.subfeatureNames.add(featureName);
    }

    public Collection<String> getSubfeatureNames() {
        return this.subfeatureNames;
    }
}

