/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.resultview.model;

import org.eclipse.core.resources.IFile;
import org.tizen.web.unittest.resultview.model.IWUTResultTreeElement;
import org.tizen.web.unittest.resultview.style.StyledString;

public class WUTResultFailure
implements IWUTResultTreeElement {
    private String message;
    private String expected;
    private String actual;
    private IFile file;
    private int lineNumber;

    public WUTResultFailure(String message, IFile file, int lineNumber) {
        this.message = message.equals("undefined") ? "failed" : message;
        this.file = file;
        this.lineNumber = lineNumber;
    }

    public WUTResultFailure(String message, String expected, String actual, IFile file, int lineNumber) {
        this(message, file, lineNumber);
        this.expected = expected;
        this.actual = actual;
    }

    public String getMessage() {
        return this.message;
    }

    public IFile getFile() {
        return this.file;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public StyledString getDetail() {
        StyledString styledString = new StyledString(this.message, StyledString.failedColor);
        if (this.expected != null) {
            styledString.appendString("\nExpected: ", StyledString.expectedColor, 1).appendString(String.valueOf(this.expected) + "\n", StyledString.expectedColor);
            styledString.appendString("Actual:", StyledString.actualColor, 1).appendString(" " + this.actual, StyledString.actualColor);
        }
        return styledString;
    }
}

