/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.step;

import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.tizen.web.unittest.resultview.ui.WUTResultView;
import org.tizen.web.zimlaunch.util.jsconsole.IJsLogReceiverJob;

public class WUTJsLogReceiverJob
implements IJsLogReceiverJob {
    private String resultXML = "";
    private IProject project;
    private ILaunchConfiguration config;
    private String mode;

    public WUTJsLogReceiverJob(IProject project, ILaunchConfiguration config, String mode) {
        this.project = project;
        this.config = config;
        this.mode = mode;
    }

    public void doJob(String message) {
        if (message == null) {
            return;
        }
        String[] splitMessage = message.split("==WUT==");
        if (splitMessage.length == 2) {
            if (splitMessage[1].equals("*starts*")) {
                this.resultXML = "";
            } else if (splitMessage[1].equals("*ends*")) {
                this.showResultView();
                this.sendResultXmlData(this.resultXML);
            } else {
                this.resultXML = String.valueOf(this.resultXML) + splitMessage[1];
            }
        }
    }

    public String getJobLogPattern() {
        return ".*==WUT==.*";
    }

    public boolean omitRestWork() {
        return true;
    }

    private void showResultView() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    page.showView("org.tizen.web.unittest.views.resultView");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void sendResultXmlData(String xml) {
        WUTResultView resultView = WUTResultView.getWUTResultView();
        resultView.displayResult(xml, this.project, this.config, this.mode);
    }
}

