/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.ProjectTreeViewerSorter;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.ValidationUtil;
import org.tizen.common.util.WorkspaceUtil;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.properties.WebProjectDefaultFilter;
import org.tizen.web.unittest.nls.NLSString;
import org.tizen.web.unittest.wizards.MethodTreeViewer;
import org.tizen.web.unittest.wizards.filter.FileTreeViewerFilter;
import org.tizen.web.unittest.wizards.filter.MethodTreeViewerFilter;
import org.tizen.web.unittest.wizards.provider.MethodTreeViewerContentProvider;
import org.tizen.web.unittest.wizards.provider.MethodTreeViewerLabelProvider;

public class WUTNewPage
extends WizardPage {
    private static final Logger logger = LoggerFactory.getLogger(WUTNewPage.class);
    private Text testFileNameText;
    private TreeViewer fileTreeViewer;
    private MethodTreeViewer methodTreeViewer;
    private Button createSetupButton;
    private Button createTeardownButton;
    private IStructuredSelection initialSelection;
    private IProject targetProject = null;
    private IDoubleClickListener doubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection selection;
            Object selectionNode;
            TreeViewer treeViewer;
            treeViewer.setExpandedState(selectionNode, !(treeViewer = (TreeViewer)event.getViewer()).getExpandedState(selectionNode = (selection = (IStructuredSelection)event.getSelection()).getFirstElement()));
        }
    };
    private ISelectionChangedListener fileTreeViewerSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (firstElement instanceof IFile) {
                IFile targetJSFile = (IFile)firstElement;
                WUTNewPage.this.targetProject = targetJSFile.getProject();
                WUTNewPage.this.testFileNameText.setText(String.valueOf(FileUtil.getFileNameWithoutExtension((String)targetJSFile.getName())) + "Test");
                WUTNewPage.this.methodTreeViewer.setInput(JavaScriptCore.createCompilationUnitFrom((IFile)targetJSFile));
            } else if (firstElement instanceof IResource) {
                WUTNewPage.this.targetProject = ((IResource)firstElement).getProject();
                WUTNewPage.this.methodTreeViewer.setInput(null);
                WUTNewPage.this.testFileNameText.setText("");
            }
        }
    };

    public WUTNewPage(IStructuredSelection selection) {
        super("wizardPage");
        this.setTitle(NLSString.LABEL_WUT_WIZARD_PAGE_TITLE);
        this.initialSelection = selection;
    }

    public void createControl(Composite parent) {
        Composite baseComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        baseComposite.setLayout((Layout)gridLayout);
        Label selectFileLabel = new Label(baseComposite, 0);
        selectFileLabel.setText(NLSString.LABEL_WUT_WIZARD_PAGE_SELECT_FILE);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        selectFileLabel.setLayoutData((Object)gridData);
        Composite leftComposite = new Composite(baseComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        leftComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        leftComposite.setLayoutData((Object)gridData);
        Composite rightComposite = new Composite(baseComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        rightComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(1040);
        rightComposite.setLayoutData((Object)gridData);
        Composite treeViewerComposite = new Composite(leftComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        treeViewerComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        treeViewerComposite.setLayoutData((Object)gridData);
        Composite bottomComposite = new Composite(leftComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        bottomComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        bottomComposite.setLayoutData((Object)gridData);
        this.fileTreeViewer = new TreeViewer(treeViewerComposite, 2052);
        gridData = new GridData(1808);
        gridData.minimumHeight = 200;
        this.fileTreeViewer.getControl().setLayoutData((Object)gridData);
        this.fileTreeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.fileTreeViewer.setSorter((ViewerSorter)new ProjectTreeViewerSorter());
        this.fileTreeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.fileTreeViewer.addFilter((ViewerFilter)new WebProjectDefaultFilter());
        this.fileTreeViewer.addFilter((ViewerFilter)new FileTreeViewerFilter());
        this.fileTreeViewer.addDoubleClickListener(this.doubleClickListener);
        this.fileTreeViewer.addSelectionChangedListener(this.fileTreeViewerSelectionChangedListener);
        this.methodTreeViewer = new MethodTreeViewer(treeViewerComposite);
        gridData = new GridData(1808);
        gridData.minimumHeight = 200;
        this.methodTreeViewer.getControl().setLayoutData((Object)gridData);
        this.methodTreeViewer.setContentProvider((IContentProvider)new MethodTreeViewerContentProvider());
        this.methodTreeViewer.setLabelProvider((IBaseLabelProvider)new MethodTreeViewerLabelProvider());
        this.methodTreeViewer.addFilter(new MethodTreeViewerFilter());
        this.methodTreeViewer.addDoubleClickListener(this.doubleClickListener);
        Label nameLabel = new Label(bottomComposite, 0);
        nameLabel.setText(NLSString.LABEL_WUT_WIZARD_PAGE_TEST_FILE_NAME);
        this.testFileNameText = new Text(bottomComposite, 2048);
        gridData = new GridData(768);
        this.testFileNameText.setLayoutData((Object)gridData);
        this.testFileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WUTNewPage.this.validateTestFileName();
            }
        });
        Button selectAllButton = new Button(rightComposite, 0);
        gridData = new GridData(768);
        selectAllButton.setLayoutData((Object)gridData);
        selectAllButton.setText(NLSString.LABEL_WUT_WIZARD_PAGE_SELECT_ALL);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WUTNewPage.this.selectAll(true);
            }
        });
        Button deselectAllButton = new Button(rightComposite, 0);
        deselectAllButton.setLayoutData((Object)gridData);
        deselectAllButton.setText(NLSString.LABEL_WUT_WIZARD_PAGE_DESELECT_ALL);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WUTNewPage.this.selectAll(false);
            }
        });
        Label additionalWorkLabel = new Label(bottomComposite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        additionalWorkLabel.setLayoutData((Object)gridData);
        additionalWorkLabel.setText(NLSString.LABEL_WUT_WIZARD_PAGE_ADDITIONAL_WORK);
        new Label(bottomComposite, 0);
        this.createSetupButton = new Button(bottomComposite, 32);
        this.createSetupButton.setText(NLSString.LABEL_WUT_WIZARD_PAGE_CREATE_SETUP);
        new Label(bottomComposite, 0);
        this.createTeardownButton = new Button(bottomComposite, 32);
        this.createTeardownButton.setText(NLSString.LABEL_WUT_WIZARD_PAGE_CREATE_TEARDOWN);
        this.initializeTree();
        this.setControl((Control)baseComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.tizen.ide.web.web_unit_test_context");
    }

    private void validateTestFileName() {
        if (WorkspaceUtil.getTizenWebProjects().length == 0) {
            this.setPageNotComplete(NLSString.LABEL_NO_WEB_PROJECT);
            return;
        }
        String testFileName = this.testFileNameText.getText();
        if (testFileName.length() == 0) {
            this.setPageNotComplete(NLSString.LABEL_NAME_MUST_NOT_BE_EMPTY);
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(testFileName, 1);
        if (!nameStatus.isOK() || !ValidationUtil.checkForFileURI((String)testFileName)) {
            this.setPageNotComplete(NLSString.LABEL_INVALID_FILE_NAME);
            return;
        }
        String testFilePath = "webUnitTest" + File.separator + "tests" + File.separator + testFileName + ".js";
        if (this.targetProject.exists((IPath)new Path(testFilePath))) {
            this.setPageNotComplete(NLSString.LABEL_TYPE_ALREADY_EXISTS);
            return;
        }
        this.setPageComplete();
    }

    private void setPageComplete(String message, int icon) {
        this.setPageComplete(true);
        this.setMessage(message, icon);
    }

    private void setPageComplete() {
        this.setPageComplete(NLSString.LABEL_WUT_WIZARD_PAGE_FINISH, 0);
    }

    private void setPageNotComplete(String message) {
        this.setPageComplete(false);
        this.setMessage(message, 3);
    }

    private void selectAll(boolean select) {
        IJavaScriptUnit jsUnit = (IJavaScriptUnit)this.methodTreeViewer.getInput();
        if (jsUnit == null) {
            return;
        }
        try {
            IFunction[] funcs;
            IFunction[] iFunctionArray = funcs = jsUnit.getFunctions();
            int n = funcs.length;
            int n2 = 0;
            while (n2 < n) {
                IFunction func = iFunctionArray[n2];
                this.methodTreeViewer.setChecked(func, select);
                ++n2;
            }
            IType[] types = jsUnit.getTypes();
            iFunctionArray = types;
            n = types.length;
            n2 = 0;
            while (n2 < n) {
                IFunction type = iFunctionArray[n2];
                this.methodTreeViewer.setSubtreeChecked(type, select);
                ++n2;
            }
        }
        catch (JavaScriptModelException e) {
            logger.error(NLSString.MSG_FAIL_TO_GET_JS_UNIT, (Throwable)e);
        }
    }

    private void initializeTree() {
        this.fileTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        if (this.initialSelection == null || this.initialSelection.isEmpty() || this.initialSelection.size() > 1) {
            this.validateTestFileName();
            return;
        }
        Object firstElement = this.initialSelection.getFirstElement();
        if (firstElement instanceof IResource) {
            IResource resource = (IResource)firstElement;
            IProject project = resource.getProject();
            if (ProjectUtil.isWebProject((IProject)project)) {
                this.fileTreeViewer.setExpandedState((Object)project, true);
                this.fileTreeViewer.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{project})));
            }
            this.fileTreeViewer.setExpandedState(firstElement, true);
            this.fileTreeViewer.setSelection((ISelection)this.initialSelection);
        }
    }

    public String getTestFileName() {
        return this.testFileNameText.getText();
    }

    public List<String> getCheckedMethodList() {
        Object[] checkedElements;
        ArrayList<String> checkedMethodNameList = new ArrayList<String>();
        Object[] objectArray = checkedElements = this.methodTreeViewer.getCheckedElements();
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            if (checkedElement instanceof IFunction) {
                checkedMethodNameList.add(((IFunction)checkedElement).getElementName());
            }
            ++n2;
        }
        return checkedMethodNameList;
    }

    public boolean isSetupChecked() {
        return this.createSetupButton.getSelection();
    }

    public boolean isTeardownChecked() {
        return this.createTeardownButton.getSelection();
    }

    public IProject getSelectedProject() {
        return this.targetProject;
    }
}

