/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder;

import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.ValidationUtil;
import org.tizen.common.verrari.IModelProvider;
import org.tizen.web.builder.UIFWBuilder;
import org.tizen.web.common.template.model.TizenCowhideModel;

public class CowhideBuilder
extends UIFWBuilder {
    public static final String RESOURCE_LAYER_NAME = "cowhide framework layer";
    private boolean useMin = false;
    private TizenCowhideModel uifwModel;
    private static String COWHIDE_DIR = "cowhide";

    public CowhideBuilder(boolean isExclude, FileHandler fh) {
        super(isExclude, fh);
    }

    public CowhideBuilder(boolean isExclude, String outputPath) {
        super(isExclude, outputPath);
    }

    @Override
    public boolean canBuild(IResource resource) {
        if (resource == null) {
            return false;
        }
        return this.isUIFWLibrary(resource.getPath()) || ValidationUtil.checkForWidgetContentFileExtension((String)resource.getName());
    }

    @Override
    protected boolean isUIFWLibrary(String path) {
        String[] dirs = FilenameUtil.getCanonicalFragments((String)path);
        if (dirs == null) {
            return false;
        }
        if (dirs[0].equals(COWHIDE_DIR)) {
            return true;
        }
        return dirs.length >= 3 && dirs[0].equals("res") && dirs[1].equals("wgt") && dirs[2].equals(COWHIDE_DIR);
    }

    @Override
    protected IModelProvider getModelProvider() {
        if (this.uifwModel == null) {
            this.uifwModel = new TizenCowhideModel(this.useMin);
        }
        return this.uifwModel;
    }
}

