/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.ui.commandbar;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.ui.commandbar.AbstractProjectCreator;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.apptemplate.model.BuildProperty;
import org.tizen.web.project.wizard.WizardMessages;
import org.tizen.web.project.wizard.model.ProjectTemplate;
import org.tizen.web.project.wizard.model.TizenTemplateLibrariesPool;
import org.tizen.web.project.wizard.ui.NewWebAppProjectWizard;
import org.tizen.web.project.wizard.ui.NewWebAppProjectWizardOptionPage;
import org.tizen.web.project.wizard.ui.NewWebAppProjectWizardPage;
import org.tizen.web.project.wizard.ui.commandbar.TizenWebUIFWOptions;
import org.tizen.web.project.wizard.ui.commandbar.TizenWebUIFWSupportLibraries;

public class WebProjectCreator
extends AbstractProjectCreator {
    String sampleRoot = String.valueOf(InstallPathConfig.getSamplesPath(null, null)) + File.separator + "web";
    String templateRoot = String.valueOf(this.sampleRoot) + File.separator + "Template" + File.separator + "Tizen";

    public void createProject(String name, String[] args) {
        ProjectTemplate template;
        super.init(String.format("Creating a web project '%s'...", name));
        final NewWebAppProjectWizard wizard = new NewWebAppProjectWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        NewWebAppProjectWizardPage mainPage = new NewWebAppProjectWizardPage(WizardMessages.NewWizardMainPageName){

            @Override
            public boolean isExistProject() {
                return false;
            }

            public boolean useDefaults() {
                return true;
            }
        };
        mainPage.setInitialProjectName(name);
        boolean isUIFW = ArrayUtil.contains((Object[])args, (Object)"uifw");
        ProjectTemplate projectTemplate = template = isUIFW ? this.createUIFWTemplate() : this.createBasicTemplate();
        if (template == null) {
            return;
        }
        mainPage.setSelectedTemplate((Object)template);
        wizard.addPage((IWizardPage)mainPage);
        NewWebAppProjectWizardOptionPage optionPage = new NewWebAppProjectWizardOptionPage(WizardMessages.NewWizardOptionPageName);
        optionPage.setTizenTemplateLibrariesPool(new TizenTemplateLibrariesPool(template.getProfileInfo()));
        wizard.addPage((IWizardPage)optionPage);
        WizardDialog wd = new WizardDialog(SWTUtil.getShell(), (IWizard)wizard){

            protected Control createContents(Composite parent) {
                this.createDialogArea(parent);
                this.createButtonBar(parent);
                return null;
            }
        };
        wd.create();
        this.println("  Generating a project...");
        super.finish(new Runnable(){

            @Override
            public void run() {
                wizard.performFinish();
            }
        });
    }

    private ProjectTemplate createTemplate(String name, String path) {
        String templatePath = String.valueOf(this.templateRoot) + File.separator + path;
        if (!new File(templatePath).exists()) {
            this.println(String.format("\nFailed to find a template from '%s'", templatePath));
            return null;
        }
        ProjectTemplate template = new ProjectTemplate(null, name, null);
        template.setTemplateRoot(templatePath);
        template.setWidgetType("TIZEN");
        return template;
    }

    private ProjectTemplate createBasicTemplate() {
        String name = "Basic Application";
        this.println(String.format("  Creating a [%s] template...", name));
        String path = "Basic" + File.separator + "Tizen_Blank";
        if (!new File(String.valueOf(this.templateRoot) + File.separator + path).exists()) {
            File basicDir = new File(String.valueOf(this.templateRoot) + File.separator + "Basic");
            Object[] files = basicDir.listFiles();
            boolean found = false;
            if (!ArrayUtil.isEmpty((Object[])files)) {
                Object[] objectArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    Object file = objectArray[n2];
                    if (((File)file).isDirectory() && FileUtil.isExist((String)(String.valueOf(((File)file).getAbsolutePath()) + File.separator + "description.xml"))) {
                        path = "Basic" + File.separator + basicDir.toURI().relativize(((File)file).toURI()).getPath();
                        this.println(String.format("   Trying to load a template from '%s'...", path));
                        found = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!found) {
                this.println(String.format("\nFailed to find a basic template from '%s'", basicDir));
                return null;
            }
        }
        return this.createTemplate(name, path);
    }

    private ProjectTemplate createUIFWTemplate() {
        String name = "Single Page Application";
        this.println(String.format("  Creating a [%s] template...", name));
        ProjectTemplate template = this.createTemplate(name, "Tizen Web UI Framework" + File.separator + "Tizen_Web_UI_FW_SinglePage");
        if (template == null) {
            this.println("  Please make sure that the template based on UI framework is not supported by this profile.");
            return null;
        }
        TizenWebUIFWOptions options = new TizenWebUIFWOptions();
        TizenWebUIFWSupportLibraries supportLibraries = new TizenWebUIFWSupportLibraries();
        options.setSupportLibraries(supportLibraries);
        template.setTemplateOptions(options);
        ArrayList<BuildProperty> listBuildProperty = new ArrayList<BuildProperty>();
        BuildProperty buildProperty = new BuildProperty();
        buildProperty.setKey("usedLibraryType");
        buildProperty.setValue("WebUIFramework");
        listBuildProperty.add(buildProperty);
        template.setBuildProperties(listBuildProperty);
        return template;
    }
}

