/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.packager.ui.popup;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CancellationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.packager.ide.PackageMessages;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.packager.core.PackageProcessType;
import org.tizen.web.packager.ui.WebPackager;
import org.tizen.web.packager.ui.popup.Messages;
import org.tizen.web.packager.ui.util.PackageUtil;

public class BuildPackageWithProgress
implements IRunnableWithProgress {
    private IProject project;
    private boolean isSuccess = false;
    private String resultMsg;

    public BuildPackageWithProgress(IProject project) {
        this.project = project;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        int cnt;
        IProject project;
        block12: {
            UserLogger.start((String)"web.package");
            this.handleCancel(monitor);
            project = this.getProject();
            if (project == null) {
                return;
            }
            IProject[] refProjects = project.getReferencedProjects();
            int totalCnt = refProjects.length + 2;
            monitor.beginTask(NLS.bind((String)Messages.PACKAGING_APPLICATION, (Object)project.getName()), totalCnt);
            cnt = 0;
            this.build(project, refProjects, monitor, cnt);
            this.handleCancel(monitor);
            if (!ProjectUtil.hasError((IResource)project) || PackageUtil.continueToPackage(org.tizen.web.builder.ide.Messages.DIALOG_TITLE_ERROR_IN_PROJECT, PackageMessages.DIALOG_QUESTION_CONTINUE_EVEN_IF_IT_HAS_ERROR, "pref.package.always.project.has.error")) break block12;
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException coreException) {}
            return;
        }
        try {
            try {
                WebPackager packMan = new WebPackager();
                packMan.removePackage(project);
                monitor.worked(cnt);
                packMan.setMonitor(monitor);
                packMan.createPackage(project, PackageProcessType.RELEASE);
                this.isSuccess = true;
                this.resultMsg = Messages.PACKAGE_SUCCEEDED;
                UserLogger.end((String)"web.package");
            }
            catch (Exception e) {
                FileUtil.recursiveDelete((File)new File(PackageUtil.getPackagePath((IProject)this.getProject())));
                throw new InvocationTargetException(e, e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException coreException) {}
            throw throwable;
        }
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException coreException) {}
    }

    private void build(IProject project, IProject[] refProjects, IProgressMonitor monitor, int cnt) throws CoreException {
        IProject[] iProjectArray = refProjects;
        int n = refProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject refProject = iProjectArray[n2];
            monitor.subTask(NLS.bind((String)Messages.BUILDING_REFERENCED_PROJECT, (Object)refProject.getName()));
            monitor.worked(++cnt);
            refProject.build(10, null);
            this.handleCancel(monitor);
            ++n2;
        }
        monitor.subTask(NLS.bind((String)Messages.BUILDING_PROJECT, (Object)project.getName()));
        monitor.worked(++cnt);
        project.build(10, null);
    }

    private void handleCancel(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new CancellationException();
        }
    }

    private IProject getProject() {
        return this.project;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public String getResultMessage() {
        return this.resultMsg;
    }
}

