/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.initializer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.compiler.libraries.LibraryLocation;
import org.eclipse.wst.jsdt.core.compiler.libraries.SystemLibraryLocation;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.project.initializer.AbstractLibraryInitializer;
import org.tizen.web.project.initializer.AbstractLibraryLocation;

public class TizenLibraryInitializer
extends AbstractLibraryInitializer {
    protected static final String ContainerDescription = "Tizen Support";
    public static final String CONTAINER_ID = "org.tizen.web.project.initializer.TizenLibraryInitializer";

    public LibraryLocation getLibraryLocation() {
        return TizenLibraryLocation.getInstance(this.project);
    }

    public String getDescription() {
        return ContainerDescription;
    }

    public IPath getPath() {
        return new Path(CONTAINER_ID);
    }

    static class TizenLibraryLocation
    extends AbstractLibraryLocation {
        private static Map<String, LibraryLocation> instances = new HashMap<String, LibraryLocation>();

        private TizenLibraryLocation(TizenProjectDescription tProject) {
            super(tProject);
        }

        public static synchronized LibraryLocation getInstance(IProject project) {
            TizenProjectDescription description = ProjectUtil.getTizenProjectDescription((IProject)project);
            if (description == null) {
                return SystemLibraryLocation.getInstance();
            }
            String platform = description.getPlatformName();
            LibraryLocation instance = instances.get(platform);
            if (instance == null) {
                instance = new TizenLibraryLocation(description);
                instances.put(platform, instance);
            }
            return instance;
        }

        public char[][] getLibraryFileNames() {
            return new char[][]{"tizen.js".toCharArray()};
        }

        @Override
        protected IPath getXMLPath() {
            return new Path("widlprocxmls/tizen.widlprocxml");
        }
    }
}

