/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.core.AbstractBuilder;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FontException;
import org.tizen.common.util.FontUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.web.builder.ide.Messages;
import org.tizen.web.builder.util.WebProjectUtil;
import org.tizen.web.common.WebConstant;
import org.tizen.web.config.schema.model.Metadata;
import org.tizen.web.config.schema.model.Widget;
import org.tizen.web.editor.configuration.ConfiguratorFactory;

public class FontProjectBuilder
extends AbstractBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(FontProjectBuilder.class);
    private static final String FONT_FAMILY_KEY = "font_family_name";
    private String projectPath;

    public FontProjectBuilder(String projectPath, String outputDir) {
        super(outputDir);
        this.projectPath = projectPath;
    }

    public FontProjectBuilder(String projectPath, FileHandler fh) {
        super(fh);
        this.projectPath = projectPath;
    }

    /*
     * Unable to fully structure code
     */
    public boolean canBuild(IResource resource) {
        block8: {
            block7: {
                if (!super.canBuild(resource)) {
                    return false;
                }
                configContents = null;
                if ("config.xml".equalsIgnoreCase(resource.getName())) break block7;
                IOUtil.tryClose((Object[])new Object[]{configContents});
                return false;
            }
            try {
                configContents = resource.getContents();
                ** if (!WebProjectUtil.isFontProject((InputStream)configContents)) goto lbl-1000
            }
            catch (Exception e) {
                try {
                    FontProjectBuilder.logger.error(e.getMessage(), (Throwable)e);
                }
                catch (Throwable var4_4) {
                    IOUtil.tryClose((Object[])new Object[]{configContents});
                    throw var4_4;
                }
                IOUtil.tryClose((Object[])new Object[]{configContents});
                break block8;
            }
lbl-1000:
            // 1 sources

            {
                IOUtil.tryClose((Object[])new Object[]{configContents});
                return true;
            }
lbl-1000:
            // 1 sources

            {
            }
            IOUtil.tryClose((Object[])new Object[]{configContents});
        }
        return false;
    }

    public BuildResult doBuild(IResource resource) throws BuildException {
        BuildResult result = new BuildResult(BuildResult.Status.UNKNOWN);
        InputStream configContents = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            try {
                configContents = resource.getContents();
                String fontFamilyName = this.getFontFamilyName(this.projectPath);
                if (fontFamilyName == null) {
                    result.addDependency(resource, resource);
                } else {
                    Widget widget = ConfiguratorFactory.unmarshal((InputStream)configContents);
                    this.addFontInfo(widget, fontFamilyName);
                    ConfiguratorFactory.marshal((Widget)widget, (OutputStream)os, null);
                    this.addOutputResource(result, resource, resource.getPath(), os.toByteArray());
                }
            }
            catch (Exception e) {
                throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{configContents});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{configContents});
        return result;
    }

    private void addFontInfo(Widget widget, String fontFamilyName) {
        Metadata md = new Metadata();
        md.setKey(FONT_FAMILY_KEY);
        md.setValue(fontFamilyName);
        widget.getContent().add(md);
    }

    private String getFontFamilyName(String projectPath) throws FontException, IOException {
        String result = null;
        String fontDir = FileUtil.appendPath((String)projectPath, (String)"shared/res");
        String[] stringArray = FontUtil.getFontPathList((String)fontDir, (String[])WebConstant.SUPPORT_FONT_EXTENSIONS);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fontPath = stringArray[n2];
            String tmpFamilyName = FontUtil.getFontFamilyName((String)FileUtil.appendPath((String)fontDir, (String)fontPath));
            if (result == null) {
                result = tmpFamilyName;
            } else if (!result.equalsIgnoreCase(tmpFamilyName)) {
                throw new FontException(Messages.FontProjectBuilder_ERR_MANY_FAMILY);
            }
            ++n2;
        }
        return result;
    }
}

