/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.cli.command;

import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.util.StringUtil;
import org.tizen.web.zimlaunch.cli.command.WRTCommand;

public class QueryCommand
extends WRTCommand {
    protected static final String WRT_LAUNCHER_LIST_COMMAND = "/usr/bin/wrt-launcher -l";

    @Override
    public void run(Executor executor, ExecutionContext context) throws Exception {
        this.setCommand(WRT_LAUNCHER_LIST_COMMAND);
        super.run(executor, context);
        if (this.isPrintOption()) {
            String msg = this.getResult();
            if (this.getCommand().endsWith(" 2>&1; echo $?")) {
                msg = this.deleteSuccessReturnCode(msg);
            }
            context.getPrompter().notify(msg);
        }
    }

    @Override
    public void undo(Executor executor, ExecutionContext context) throws Exception {
        super.undo(executor, context);
    }

    private String deleteSuccessReturnCode(String msg) {
        String successReturnCode = "0";
        String[] msgLines = StringUtil.split((String)msg, (String)"\n");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < msgLines.length) {
            if (i == msgLines.length - 1 && successReturnCode.equals(StringUtil.trim((String)msgLines[i]))) break;
            sb.append(msgLines[i]);
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }
}

