/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.unittest.resultview.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorUtil {
    private static final Logger logger = LoggerFactory.getLogger(EditorUtil.class);

    public static void openEditor(IFile file, int lineNumber) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IEditorPart editorPart = page.openEditor((IEditorInput)new FileEditorInput(file), "org.tizen.web.editor.javascript.JavascriptEditor");
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocumentProvider provider = textEditor.getDocumentProvider();
            IEditorInput input = textEditor.getEditorInput();
            provider.connect((Object)input);
            IDocument document = provider.getDocument((Object)input);
            IRegion region = document.getLineInformation(lineNumber - 1);
            textEditor.selectAndReveal(region.getOffset(), region.getLength());
        }
        catch (PartInitException e) {
            logger.error("Failed to open editor", (Throwable)e);
        }
        catch (CoreException e) {
            logger.error("Failed to open editor", (Throwable)e);
        }
        catch (BadLocationException e) {
            logger.error("Failed to open editor", (Throwable)e);
        }
    }
}

