/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.ui.wizards.model.Category;
import org.tizen.common.ui.wizards.model.Template;
import org.tizen.web.model.TizenAppTemplate;
import org.tizen.web.model.TizenModelFactory;
import org.tizen.web.project.wizard.model.ProjectTemplate;

public abstract class AbstractTemplateLoader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String APP_TEMPLATE_XML = "tizen-app-template.xml";

    public AbstractTemplateLoader() {
        this.initialize();
    }

    public AbstractTemplateLoader(Category root) {
        this.initialize(root);
    }

    protected abstract void initialize();

    protected void initialize(Category root) {
        this.initialize();
    }

    protected TizenAppTemplate unmarshalAppTemplate(String path) throws FileNotFoundException {
        TizenAppTemplate tizenAppTemplate = TizenModelFactory.unmarshalAppTemplate((String)path);
        if (tizenAppTemplate == null) {
            this.logger.warn("Fail to unmarshaling information in the template : {0}", (Object)path);
        }
        return tizenAppTemplate;
    }

    protected TizenAppTemplate unmarshalAppTemplate(InputStream inputStream) throws FileNotFoundException {
        TizenAppTemplate tizenAppTemplate = TizenModelFactory.unmarshalAppTemplate((InputStream)inputStream);
        if (tizenAppTemplate == null) {
            this.logger.warn("Fail to unmarshaling information in the template : {0}");
        }
        return tizenAppTemplate;
    }

    protected Category getGroup(Category parentGroup, String name, String icon) {
        assert (name != null);
        if (parentGroup != null) {
            for (Category child : parentGroup.getChildren()) {
                if (!name.equals(child.getName())) continue;
                return child;
            }
        }
        Category group = new Category(parentGroup, name, icon);
        return group;
    }

    protected Category getGroup(Category parentGroup, String name) {
        return this.getGroup(parentGroup, name, null);
    }

    protected Category createEntry(Category parentGroup, String name) {
        assert (parentGroup != null);
        assert (name != null);
        for (Object obj : parentGroup.getChildren()) {
            Category child;
            if (!(obj instanceof Category) || !name.equals((child = (Category)obj).getName())) continue;
            return child;
        }
        Category projectTypeEntry = new Category(parentGroup, name, null);
        return projectTypeEntry;
    }

    protected ProjectTemplate createProjectTemplate(Category parentEntry, TizenAppTemplate tizenAppTemplate) throws FileNotFoundException {
        return this.createProjectTemplate(parentEntry, tizenAppTemplate, null);
    }

    protected ProjectTemplate createProjectTemplate(Category parentEntry, TizenAppTemplate tizenAppTemplate, ProfileInfo platformInfo) throws FileNotFoundException {
        assert (parentEntry != null);
        assert (tizenAppTemplate != null);
        Object[] objectArray = parentEntry.getTemplates();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof ProjectTemplate) {
                ProjectTemplate child = (ProjectTemplate)((Object)obj);
                if (tizenAppTemplate.getTemplateName().equals(child.getName())) {
                    this.logger.warn("Detected duplicate template name. this name must be unique within same category: " + child.getName());
                    break;
                }
            }
            ++n2;
        }
        String descPath = String.valueOf(tizenAppTemplate.getTemplateRoot()) + File.separator + tizenAppTemplate.getDescriptionFileName();
        ProjectTemplate template = new ProjectTemplate(parentEntry, tizenAppTemplate.getTemplateName(), descPath, platformInfo);
        template.setWidgetType(tizenAppTemplate.getWidgetType());
        template.setTemplateRoot(tizenAppTemplate.getTemplateRoot());
        template.setIcons(tizenAppTemplate.getIconList());
        template.setTemplateOptions(tizenAppTemplate.getOptions());
        template.setBuildProperties(tizenAppTemplate.getBuildProperty());
        parentEntry.addTemplate((Template)template);
        return template;
    }

    protected boolean removeChild(Category group, String name) {
        assert (group != null);
        assert (name != null);
        for (Object entryObj : group.getChildren()) {
            Category entry;
            if (!(entryObj instanceof Category) || !name.equals((entry = (Category)entryObj).getName())) continue;
            return group.removeChild(entry);
        }
        return false;
    }
}

