/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.operation;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.tizen.common.util.FreeMarkerUtil;
import org.tizen.web.apptemplate.model.LibraryElement;
import org.tizen.web.apptemplate.model.OptionElement;
import org.tizen.web.apptemplate.model.OptionGroup;
import org.tizen.web.apptemplate.model.Options;
import org.tizen.web.apptemplate.model.SupportLibraries;
import org.tizen.web.project.wizard.WizardMessages;
import org.tizen.web.project.wizard.model.ProjectTemplate;
import org.tizen.web.project.wizard.model.TizenTemplateLibrariesPool;
import org.tizen.web.project.wizard.model.TizenTemplateLibraryGroup;
import org.tizen.web.project.wizard.operation.AbstractProjectTemplateOperation;

public class OptionProcessOperation
extends AbstractProjectTemplateOperation {
    private Map<String, Object> root = new HashMap<String, Object>();
    private Configuration cfg = FreeMarkerUtil.getDefaultConfiguration();
    private static String temporaryFileAdditionalName = ".template";
    private static String optionGroupSeparator = "_";
    private int subTicks = 0;
    TizenTemplateLibrariesPool pool;

    public OptionProcessOperation(TizenTemplateLibrariesPool pool) {
        this.pool = pool;
        this.setMainTask(WizardMessages.NewWizardCopyTemplateOperationTask);
    }

    @Override
    public boolean operation(ProjectTemplate template, IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        this.subTicks = 200;
        if (template == null) {
            this.logger.debug("ProjectTemplate is null. It must be not null.");
            return false;
        }
        Options options = template.getTemplateOptions();
        if (options == null) {
            return true;
        }
        this.setTemplateDirectoryForFreeMarker(project);
        SupportLibraries supportLibraries = options.getSupportLibraries();
        if (supportLibraries != null) {
            this.buildModelForSupportLibraries(supportLibraries);
        }
        for (OptionGroup optionGroup : options.getOptionGroup()) {
            this.buildModelForOptionGroup(optionGroup, optionGroup.getKey());
        }
        IResource[] iResourceArray = project.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (this.isAvailableTemplate(member)) {
                this.generateHTML(member.getName(), project, monitor);
            }
            ++n2;
        }
        return true;
    }

    private boolean isAvailableTemplate(IResource member) {
        String res;
        String[] availableExtension = new String[]{"html"};
        String[] availableList = new String[]{"app.xml"};
        String[] stringArray = availableExtension;
        int n = availableExtension.length;
        int n2 = 0;
        while (n2 < n) {
            res = stringArray[n2];
            if (res.equalsIgnoreCase(member.getFileExtension())) {
                return true;
            }
            ++n2;
        }
        stringArray = availableList;
        n = availableList.length;
        n2 = 0;
        while (n2 < n) {
            res = stringArray[n2];
            if (res.equalsIgnoreCase(member.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void generateHTML(String originalContent, IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        String templateContent = String.valueOf(originalContent) + temporaryFileAdditionalName;
        IFile contentResource = project.getFile(originalContent);
        Path templateContentPath = new Path(templateContent);
        contentResource.move((IPath)templateContentPath, true, this.createSubMonitor(monitor, this.subTicks));
        try {
            try {
                String originalContentAbsolutePath = new File(contentResource.getLocationURI()).getAbsolutePath();
                FreeMarkerUtil.generateDocument(this.root, (Configuration)this.cfg, (String)templateContent, (String)originalContentAbsolutePath);
                contentResource.refreshLocal(0, this.createSubMonitor(monitor, this.subTicks));
            }
            catch (TemplateException e) {
                contentResource.refreshLocal(0, this.createSubMonitor(monitor, this.subTicks));
                project.getFile(originalContent).delete(true, this.createSubMonitor(monitor, this.subTicks));
                String errorMsg = "Fail to generate HTML files.";
                throw this.createCoreException(4, errorMsg, e);
            }
        }
        finally {
            project.getFile((IPath)templateContentPath).delete(true, this.createSubMonitor(monitor, this.subTicks));
        }
    }

    private void buildModelForOptionGroup(OptionGroup optionGroup, String key) {
        for (OptionElement optionElement : optionGroup.getOptionElement()) {
            boolean isDefault = optionElement.isDefaultElement() != null ? optionElement.isDefaultElement() : false;
            String addedKey = String.valueOf(key) + optionGroupSeparator + optionElement.getKey();
            String value = optionElement.getValue();
            switch (optionGroup.getOptionType()) {
                case MANDATORY: {
                    this.root.put(addedKey, value);
                    break;
                }
                case MULTI_SELECTION: {
                    this.root.put(addedKey, isDefault ? value : "");
                    break;
                }
                case SINGLE_SELECTION: {
                    if (!isDefault) break;
                    this.root.put(key, value);
                }
            }
        }
        for (OptionGroup innerOptionGroup : optionGroup.getOptionGroup()) {
            String addedKey = String.valueOf(key) + optionGroupSeparator + innerOptionGroup.getKey();
            this.buildModelForOptionGroup(innerOptionGroup, addedKey);
        }
    }

    private void setTemplateDirectoryForFreeMarker(IProject project) throws CoreException, IOException {
        File projectDir = new File(project.getLocationURI());
        this.cfg.setDirectoryForTemplateLoading(projectDir);
    }

    private void buildModelForSupportLibraries(SupportLibraries supportLibraries) {
        if (this.pool != null) {
            List<TizenTemplateLibraryGroup> groupList = this.pool.getLibraryGroupWithDepends(supportLibraries);
            for (TizenTemplateLibraryGroup group : groupList) {
                String value;
                String key = group.getKey();
                LibraryElement selectedElement = group.getSelectedElement();
                String string = value = group.isSelectedMinified() ? selectedElement.getMinifiedValue() : selectedElement.getOriginalValue();
                if (value == null) continue;
                this.root.put(key, value);
            }
        }
    }
}

