/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.javascript.navigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.TizenProjectType;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.editor.contentassist.WebResourceManager;
import org.tizen.web.editor.javascript.Activator;
import org.tizen.web.editor.javascript.JavaScriptEditor;
import org.tizen.web.editor.javascript.JavaScriptEditorConstants;
import org.tizen.web.editor.javascript.navigation.SymbolInformation;
import org.tizen.web.editor.javascript.navigation.SymbolNavigatorLabelProvider;
import org.tizen.web.editor.javascript.navigation.SymbolNavigatorListSelectionDialog;
import org.tizen.web.editor.javascript.navigation.SymbolNavigatorUILabelProvider;
import org.tizen.web.editor.javascript.navigation.SymbolNavigatorVisitor;
import org.tizen.web.editor.javascript.util.JavaScriptEditorUtil;

public class SymbolNavigatorHandler
extends AbstractHandler
implements IHandler,
JavaScriptEditorConstants {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor = SWTUtil.getActiveEditor();
        if (activeEditor == null || !(activeEditor instanceof JavaScriptEditor)) {
            throw new ExecutionException("The editor part is null or not javascript editor.");
        }
        IFileEditorInput fileEditorInput = (IFileEditorInput)activeEditor.getEditorInput();
        IFile currentEditorInputFile = fileEditorInput.getFile();
        IProject project = currentEditorInputFile.getProject();
        ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)project);
        if (tizenProject != null && (tizenProject.getTizenProjectType() == TizenProjectType.TIZEN_WEB_APPLICATION || tizenProject.getTizenProjectType() == TizenProjectType.TIZEN_WEB_UIFW_APPLICATION)) {
            this.createSymbolNavigator(activeEditor, currentEditorInputFile);
        }
        return null;
    }

    private void createSymbolNavigator(IEditorPart activeEditor, IFile currentEditorInputFile) throws ExecutionException {
        SymbolInformation symbolInformation;
        Shell shell = activeEditor.getSite().getShell();
        SymbolNavigatorUILabelProvider lprovider = new SymbolNavigatorUILabelProvider(3976933559779370L, 1);
        SymbolNavigatorLabelProvider decoratingJavaLabelProvider = new SymbolNavigatorLabelProvider((JavaUILabelProvider)lprovider);
        SymbolNavigatorListSelectionDialog symbolNavigator = new SymbolNavigatorListSelectionDialog(shell, (ILabelProvider)decoratingJavaLabelProvider, currentEditorInputFile);
        symbolNavigator.setTitle("Symbol Search & Navigation");
        symbolNavigator.setMessage("Search the symbols started with a given String :");
        symbolNavigator.setMultipleSelection(false);
        symbolNavigator.setHelpAvailable(false);
        List<SymbolInformation> allSymbolList = SymbolNavigatorHandler.makeSymbolInformations(currentEditorInputFile);
        Collections.sort(allSymbolList);
        symbolNavigator.setElements(allSymbolList.toArray());
        int result = symbolNavigator.open();
        decoratingJavaLabelProvider.dispose();
        if (result == 0 && (symbolInformation = (SymbolInformation)symbolNavigator.getFirstResult()) != null) {
            if (symbolInformation.getFile().equals((Object)currentEditorInputFile)) {
                ((JavaScriptEditor)activeEditor).setHighlightRange(symbolInformation.getSymbolOffset(), symbolInformation.getSymbolLength(), true);
            } else {
                boolean editable = symbolInformation.isEditable();
                if (editable) {
                    JavaScriptEditorUtil.openEditor(symbolInformation.getFile(), symbolInformation.getSymbolOffset(), symbolInformation.getSymbolLength());
                } else {
                    IClassFile classFile = (IClassFile)symbolInformation.getJavaScriptElement();
                    if (classFile != null) {
                        JavaScriptEditorUtil.openEditor(classFile, true, symbolInformation.getSymbolOffset(), symbolInformation.getSymbolLength());
                    }
                }
            }
        }
    }

    public static List<SymbolInformation> makeSymbolInformations(IFile currentEditorInputFile) throws ExecutionException {
        List<IJavaScriptElement> includedJavaScriptLibraries;
        IJavaScriptProject currentJavaScriptProject;
        ArrayList<SymbolInformation> allSymbolList = new ArrayList<SymbolInformation>();
        IPreferenceStore jsEditorPreferenceStore = Activator.getJsEditorPreferenceStore();
        String scopeStoreValue = jsEditorPreferenceStore.getString("org.tizen.web.editor.javascript.JS_EDITOR_SYMBOL_NAVIGATOR_SCOPE_STORE_KEY");
        IProject project = currentEditorInputFile.getProject();
        WebResourceManager resourceManager = new WebResourceManager(project);
        resourceManager.makeProjectManagedResourceMap();
        Map jsFiles = resourceManager.getJsFiles();
        if (!(jsFiles != null && jsFiles.size() != 0 || scopeStoreValue.equals("SYMBOL_NAVIGATOR_STORE_SCOPE_VALUE_WHOLE"))) {
            return allSymbolList;
        }
        if (jsFiles != null) {
            Set jsFileEntrySet = jsFiles.entrySet();
            for (Map.Entry jsFileEntry : jsFileEntrySet) {
                IFile jsFile = (IFile)jsFileEntry.getValue();
                if (scopeStoreValue.equals("SYMBOL_NAVIGATOR_STORE_SCOPE_VALUE_THIS_FILE") && !currentEditorInputFile.getFullPath().toString().equals(jsFile.getFullPath().toString())) continue;
                IJavaScriptElement jsModel = JavaScriptCore.create((IFile)jsFile);
                JavaScriptUnit javaScriptUnitAST = JavaScriptPlugin.getDefault().getASTProvider().getAST(jsModel, ASTProvider.WAIT_NO, null);
                if (javaScriptUnitAST == null) {
                    javaScriptUnitAST = (JavaScriptUnit)JavaScriptEditorUtil.parseJavaScript((ICompilationUnit)jsModel);
                }
                SymbolNavigatorVisitor symbolNavigatorVistor = new SymbolNavigatorVisitor(jsFile, javaScriptUnitAST, true, jsModel);
                javaScriptUnitAST.accept((ASTVisitor)symbolNavigatorVistor);
                List<SymbolInformation> symbolList = symbolNavigatorVistor.getSymbolList();
                if (symbolList == null || symbolList.size() <= 0) continue;
                allSymbolList.addAll(symbolList);
            }
        }
        if (scopeStoreValue.equals("SYMBOL_NAVIGATOR_STORE_SCOPE_VALUE_WHOLE") && (currentJavaScriptProject = JavaScriptEditorUtil.getCurrentJavaScriptProject(project)) != null && (includedJavaScriptLibraries = JavaScriptEditorUtil.getIncludedJavaScriptLibraries(currentJavaScriptProject)) != null && includedJavaScriptLibraries.size() > 0) {
            for (IJavaScriptElement javaScriptUnit : includedJavaScriptLibraries) {
                if (!(javaScriptUnit instanceof Openable)) continue;
                JavaScriptUnit javaScriptUnitAST = (JavaScriptUnit)JavaScriptEditorUtil.parseJavaScript((ICompilationUnit)javaScriptUnit);
                IPath path = javaScriptUnit.getPath();
                IFile jsFile = JavaScriptEditorUtil.findFileResourceByLocation(path);
                SymbolNavigatorVisitor symbolNavigatorVistor = null;
                symbolNavigatorVistor = javaScriptUnit instanceof IClassFile ? new SymbolNavigatorVisitor(jsFile, javaScriptUnitAST, false, javaScriptUnit) : new SymbolNavigatorVisitor(jsFile, javaScriptUnitAST, true, javaScriptUnit);
                javaScriptUnitAST.accept((ASTVisitor)symbolNavigatorVistor);
                List<SymbolInformation> symbolList = symbolNavigatorVistor.getSymbolList();
                if (symbolList == null || symbolList.size() <= 0) continue;
                allSymbolList.addAll(symbolList);
            }
        }
        return allSymbolList;
    }
}

