/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.javascript.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.css.ui.internal.image.CSSImageHelper;
import org.eclipse.wst.html.core.internal.document.DOMStyleModelImpl;
import org.eclipse.wst.html.core.internal.document.DocumentStyleImpl;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.html.ui.internal.editor.HTMLEditorPluginImageHelper;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.LibraryPackageFragment;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeImpl;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.editor.javascript.JavaScriptEditor;
import org.tizen.web.editor.javascript.JavaScriptEditorConstants;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JavaScriptEditorUtil
implements JavaScriptEditorConstants {
    protected static final Logger logger = LoggerFactory.getLogger(JavaScriptEditorUtil.class);

    public static List<IFile> findLinkedHtml(Map<String, IResource> htmlFiles, String jsFilePath) {
        ArrayList<IFile> linkedHtmls = new ArrayList<IFile>();
        Set<Map.Entry<String, IResource>> htmlFileEntrySet = htmlFiles.entrySet();
        for (Map.Entry<String, IResource> htmlFileEntry : htmlFileEntrySet) {
            IFile htmlFile = (IFile)htmlFileEntry.getValue();
            boolean isExist = JavaScriptEditorUtil.isExistLinkInformation(htmlFile, jsFilePath);
            if (!isExist) continue;
            linkedHtmls.add(htmlFile);
        }
        return linkedHtmls;
    }

    private static boolean isExistLinkInformation(IFile file, String jsFilePath) {
        boolean isExist;
        block9: {
            isExist = false;
            try {
                IDOMDocument document;
                NodeList scriptNodes;
                IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(file);
                if (model == null || (scriptNodes = (document = ((DOMStyleModelImpl)model).getDocument()).getElementsByTagName("script")) == null) break block9;
                int i = 0;
                while (i < scriptNodes.getLength()) {
                    Node item = scriptNodes.item(i);
                    String attribute = ((ElementStyleImpl)item).getAttribute("src");
                    if (attribute != null) {
                        if (attribute.contains("\\")) {
                            attribute = attribute.replace("\\", "/");
                        }
                        if (attribute.startsWith("/")) {
                            attribute = attribute.substring(1);
                        }
                        if (attribute.startsWith("./")) {
                            attribute = attribute.substring(2);
                        }
                        if (!(attribute = JavaScriptEditorUtil.removeParentFolderPrefix(attribute)).trim().equals("") && jsFilePath.contains(attribute)) {
                            isExist = true;
                            break;
                        }
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return isExist;
    }

    private static String removeParentFolderPrefix(String path) {
        if (path.startsWith("../") && (path = path.replace("../", "")).startsWith("../")) {
            path = JavaScriptEditorUtil.removeParentFolderPrefix(path);
        }
        return path;
    }

    public static List<ElementStyleImpl> getElements(IDOMDocument document) {
        ArrayList<ElementStyleImpl> elements = new ArrayList<ElementStyleImpl>();
        NodeList childNodes = document.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node item = childNodes.item(i);
            if (item instanceof ElementStyleImpl) {
                JavaScriptEditorUtil.getElements(item, elements);
            }
            ++i;
        }
        return elements;
    }

    private static List<ElementStyleImpl> getElements(Node node, List<ElementStyleImpl> elements) {
        elements.add((ElementStyleImpl)node);
        NodeList currentItemChildNodes = node.getChildNodes();
        if (currentItemChildNodes != null) {
            int i = 0;
            while (i < currentItemChildNodes.getLength()) {
                Node item = currentItemChildNodes.item(i);
                if (item instanceof ElementStyleImpl) {
                    JavaScriptEditorUtil.getElements(item, elements);
                }
                ++i;
            }
        }
        return elements;
    }

    public static List<ElementStyleImpl> getElementsHaveGivenNameAttribute(IDOMDocument document, String attributeName) {
        ArrayList<ElementStyleImpl> elementsHaveGivenNameAttribute = new ArrayList<ElementStyleImpl>();
        if (attributeName == null || attributeName.trim().equals("")) {
            return elementsHaveGivenNameAttribute;
        }
        NodeList childNodes = document.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node item = childNodes.item(i);
            if (item instanceof ElementStyleImpl) {
                JavaScriptEditorUtil.getElementsHaveGivenNameAttribute(item, elementsHaveGivenNameAttribute, attributeName);
            }
            ++i;
        }
        return elementsHaveGivenNameAttribute;
    }

    public static ElementStyleImpl getElemenGivenAttributeNameAndValue(IDOMDocument document, String attributeName, String attributeValue) {
        ElementStyleImpl foundElement = null;
        List<ElementStyleImpl> elementsHaveGivenNameAttribute = JavaScriptEditorUtil.getElementsHaveGivenNameAttribute(document, attributeName);
        for (ElementStyleImpl element : elementsHaveGivenNameAttribute) {
            String currentAttributeValue = element.getAttribute(attributeName);
            if (!attributeValue.equals(currentAttributeValue)) continue;
            foundElement = element;
            break;
        }
        return foundElement;
    }

    private static List<ElementStyleImpl> getElementsHaveGivenNameAttribute(Node node, List<ElementStyleImpl> elementsHaveGivenNameAttribute, String attributeName) {
        NodeList currentItemChildNodes;
        String attribute = ((ElementStyleImpl)node).getAttribute(attributeName);
        if (attribute != null && !attribute.trim().equals("")) {
            elementsHaveGivenNameAttribute.add((ElementStyleImpl)node);
        }
        if ((currentItemChildNodes = node.getChildNodes()) != null) {
            int i = 0;
            while (i < currentItemChildNodes.getLength()) {
                Node item = currentItemChildNodes.item(i);
                if (item instanceof ElementStyleImpl) {
                    JavaScriptEditorUtil.getElementsHaveGivenNameAttribute(item, elementsHaveGivenNameAttribute, attributeName);
                }
                ++i;
            }
        }
        return elementsHaveGivenNameAttribute;
    }

    public static ASTNode parseJavaScript(ICompilationUnit unit) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setKind(8);
        if (unit instanceof IClassFile) {
            parser.setSource((IClassFile)unit);
        } else {
            parser.setSource((IJavaScriptUnit)unit);
        }
        parser.setResolveBindings(true);
        return parser.createAST(null);
    }

    public static void openEditor(IFile file, int offset, int length) {
        IWorkbenchPage page = SWTUtil.getActivePage();
        if (page != null) {
            try {
                IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                if (openEditor instanceof StructuredTextEditor) {
                    ((StructuredTextEditor)openEditor).setHighlightRange(offset, length, true);
                } else if (openEditor instanceof JavaScriptEditor) {
                    ((JavaScriptEditor)openEditor).setHighlightRange(offset, length, true);
                }
            }
            catch (PartInitException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void openEditor(Object inputElement, boolean activate, int offset, int length) {
        try {
            IEditorPart openInEditor = EditorUtility.openInEditor((Object)inputElement, (boolean)activate);
            if (openInEditor instanceof ClassFileEditor) {
                ((ClassFileEditor)openInEditor).setHighlightRange(offset, length, true);
            }
        }
        catch (PartInitException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (JavaScriptModelException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static int getLineNumberOfElement(Node node) {
        if (node instanceof ElementStyleImpl || node instanceof AttrImpl) {
            Node firstChild;
            Node parentNode;
            IStructuredDocumentRegion startStructuredDocumentRegion = ((NodeImpl)node).getStartStructuredDocumentRegion();
            if (startStructuredDocumentRegion != null) {
                int elementStart = startStructuredDocumentRegion.getStart();
                IStructuredDocument parentDocument = startStructuredDocumentRegion.getParentDocument();
                return parentDocument.getLineOfOffset(elementStart) + 1;
            }
            String nodeName = node.getNodeName();
            if (nodeName != null && nodeName.equals("html") && (parentNode = node.getParentNode()) instanceof DocumentStyleImpl && (firstChild = parentNode.getFirstChild()) != null && firstChild instanceof DocumentTypeImpl && (startStructuredDocumentRegion = ((NodeImpl)firstChild).getStartStructuredDocumentRegion()) != null) {
                int elementStart = startStructuredDocumentRegion.getStart();
                IStructuredDocument parentDocument = startStructuredDocumentRegion.getParentDocument();
                return parentDocument.getLineOfOffset(elementStart) + 2;
            }
        }
        return -1;
    }

    public static Image createImageDescriptor(String type, String imageResourceName) {
        Image image = null;
        if ("css".equals(type)) {
            image = CSSImageHelper.getInstance().getImage(imageResourceName);
        } else if ("html".equals(type)) {
            image = HTMLEditorPluginImageHelper.getInstance().getImage(imageResourceName);
        } else if ("xml".equals(type)) {
            image = XMLEditorPluginImageHelper.getInstance().getImage(imageResourceName);
        } else if ("js".equals(type)) {
            image = JavaPluginImages.get((String)imageResourceName);
        }
        return image;
    }

    public static List<IJavaScriptElement> getIncludedJavaScriptLibraries(IJavaScriptProject javaScriptProject) {
        List<IJavaScriptElement> javaScriptUnits = new ArrayList<IJavaScriptElement>();
        try {
            IPackageFragmentRoot[] allPackageFragmentRoots = javaScriptProject.getAllPackageFragmentRoots();
            if (allPackageFragmentRoots != null && allPackageFragmentRoots.length > 0) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = allPackageFragmentRoots;
                int n = allPackageFragmentRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaScriptElement[] packageFragments;
                    IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                    IJavaScriptProject thisJavaScriptProject = packageFragmentRoot.getJavaScriptProject();
                    if ((packageFragmentRoot instanceof LibraryFragmentRoot || !thisJavaScriptProject.equals(javaScriptProject)) && (packageFragments = packageFragmentRoot.getChildren()) != null && packageFragments.length > 0) {
                        IJavaScriptElement[] iJavaScriptElementArray = packageFragments;
                        int n3 = packageFragments.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IJavaScriptElement javaScriptElement = iJavaScriptElementArray[n4];
                            if (javaScriptElement instanceof IPackageFragment) {
                                IPackageFragment packageFragment = (IPackageFragment)javaScriptElement;
                                if (packageFragment instanceof LibraryPackageFragment) {
                                    IClassFile[] classFiles = packageFragment.getClassFiles();
                                    if (classFiles != null && classFiles.length > 0) {
                                        IClassFile[] iClassFileArray = classFiles;
                                        int n5 = classFiles.length;
                                        int n6 = 0;
                                        while (n6 < n5) {
                                            IClassFile classFile = iClassFileArray[n6];
                                            javaScriptUnits.add((IJavaScriptElement)classFile);
                                            ++n6;
                                        }
                                    }
                                } else {
                                    javaScriptUnits = JavaScriptEditorUtil.getJavaScriptUnits(javaScriptUnits, packageFragment);
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (JavaScriptModelException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return javaScriptUnits;
    }

    private static List<IJavaScriptElement> getJavaScriptUnits(List<IJavaScriptElement> javaScriptUnits, IPackageFragment packageFragment) throws JavaScriptModelException {
        IJavaScriptElement[] packageFragmentChildren = packageFragment.getChildren();
        if (packageFragmentChildren != null && packageFragmentChildren.length > 0) {
            IJavaScriptElement[] iJavaScriptElementArray = packageFragmentChildren;
            int n = packageFragmentChildren.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaScriptElement javaScriptElement = iJavaScriptElementArray[n2];
                if (javaScriptElement instanceof IJavaScriptUnit) {
                    javaScriptUnits.add(javaScriptElement);
                } else {
                    JavaScriptEditorUtil.getJavaScriptUnits(javaScriptUnits, (IPackageFragment)javaScriptElement);
                }
                ++n2;
            }
        }
        return javaScriptUnits;
    }

    public static IJavaScriptProject getCurrentJavaScriptProject(IProject currentProject) {
        try {
            JavaModel javaModel = JavaModelManager.getJavaModelManager().getJavaModel();
            IJavaScriptProject[] javaScriptProjects = javaModel.getJavaScriptProjects();
            if (javaScriptProjects != null) {
                IJavaScriptProject[] iJavaScriptProjectArray = javaScriptProjects;
                int n = javaScriptProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaScriptProject javaScriptProject = iJavaScriptProjectArray[n2];
                    IProject project = javaScriptProject.getProject();
                    if (project != null && project.equals((Object)currentProject)) {
                        return javaScriptProject;
                    }
                    ++n2;
                }
            }
        }
        catch (JavaScriptModelException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static IFile findFileResourceByLocation(IPath ResourcePath) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile(ResourcePath);
        if (file == null) {
            file = workspaceRoot.getFileForLocation(ResourcePath);
        }
        return file;
    }
}

