/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.livereload;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.livereload.IResourceProvider;

public abstract class AbstractResourceProvider
extends Observable
implements IResourceProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected IResourceProvider parent;
    protected final ArrayList<Observer> observers = new ArrayList();

    @Override
    public void setParent(IResourceProvider parent) {
        this.parent = parent;
    }

    @Override
    public void addObserver(Observer observer) {
        super.addObserver(observer);
        this.observers.add(observer);
    }

    @Override
    public long getSize(String path) throws IOException {
        byte[] bytes = this.get(path);
        if (bytes == null) {
            return -1L;
        }
        return bytes.length;
    }

    @Override
    public InputStream getContents(String path) throws IOException {
        byte[] bytes = this.get(path);
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    protected abstract byte[] get(String var1) throws IOException;
}

