/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.validation;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.PluginUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.validation.W3CNonSchemaBasedValidatorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NonSchemaBasedValidator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String NONSCHEMA_CONFIG_MARKER = "org.tizen.web.editor.configuration.problemmarker.configxmlNonSchema";

    public void validateConfigurationDocument(IFile configFile) {
        try {
            configFile.deleteMarkers(NONSCHEMA_CONFIG_MARKER, true, 2);
            TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)configFile.getProject());
            if (!ProjectUtil.isSupportedPlatform((TizenProjectDescription)tizenDesc)) {
                return;
            }
            String platformName = tizenDesc.getPlatformName();
            IConfigurationElement[] ces = PluginUtil.getExtensionConfigurationElements((String)"org.tizen.web.editor.configuration");
            W3CNonSchemaBasedValidatorHandler handler = null;
            IConfigurationElement[] iConfigurationElementArray = ces;
            int n = ces.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                if (platformName.equalsIgnoreCase(ce.getAttribute("platform"))) {
                    IConfigurationElement[] validatorCes = ce.getChildren("validator");
                    if (validatorCes == null) break;
                    IConfigurationElement[] iConfigurationElementArray2 = validatorCes;
                    int n3 = validatorCes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement validatorCe = iConfigurationElementArray2[n4];
                        if (validatorCe.getAttribute("handler") != null) {
                            handler = (W3CNonSchemaBasedValidatorHandler)validatorCe.createExecutableExtension("handler");
                            handler.init(configFile);
                        }
                        ++n4;
                    }
                    break;
                }
                ++n2;
            }
            if (handler == null) {
                handler = new W3CNonSchemaBasedValidatorHandler();
                handler.init(configFile);
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(new File(configFile.getLocation().toOSString()), (DefaultHandler)handler);
        }
        catch (ConfigurationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

