/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.server;

import java.net.BindException;
import java.util.HashMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;
import org.tizen.common.util.LocalPortChecker;
import org.tizen.common.util.log.Logger;

public class TizenHTTPServer {
    private static final String SERVER_NAME = "Tizen HTTP Server";
    private Server jettyServer;
    private int port;
    private String contextPath;
    private String deployPath;
    private HashMap<String, String> contextPathMap = new HashMap();
    public static final String STARTED = "STARTED";
    public static final String STARTING = "STARTING";
    public static final String STOPPED = "STOPPED";
    public static final String STOPPING = "STOPPING";
    public static final String RUNNING = "RUNNING";
    public static final String FAILED = "FAILED";

    public TizenHTTPServer() {
        this.port = LocalPortChecker.getAvailableLocalPort((int)1, (int)80);
        this.jettyServer = new Server(this.port);
        this.setDefaultHandler();
    }

    public TizenHTTPServer(int port) throws Exception {
        if (LocalPortChecker.getAvailableLocalPort((int)1, (int)port) < 0) {
            throw new BindException("Port " + port + " is already used");
        }
        this.port = port;
        this.jettyServer = new Server(port);
        this.setDefaultHandler();
    }

    private void setDefaultHandler() {
        DefaultHandler defHandler = new DefaultHandler();
        ContextHandlerCollection contextCol = new ContextHandlerCollection();
        contextCol.addHandler((Handler)defHandler);
        this.jettyServer.setHandler((Handler)contextCol);
        this.contextPath = "/";
        this.deployPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        this.addHandler(this.contextPath, this.deployPath, false);
    }

    public void start() {
        new Thread("Tizen HTTP Server:" + this.port){

            @Override
            public void run() {
                try {
                    TizenHTTPServer.this.jettyServer.start();
                    TizenHTTPServer.this.jettyServer.join();
                }
                catch (Exception e) {
                    Logger.log((Throwable)e);
                }
            }
        }.start();
        while (!this.isStarted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Logger.log((Throwable)e);
            }
        }
    }

    public void stop() {
        try {
            this.jettyServer.stop();
            while (!this.isStopped()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Logger.log((Throwable)e);
                }
            }
            Log.info((String)this.getState(), (Object)this.jettyServer);
        }
        catch (Exception e) {
            Logger.log((Throwable)e);
        }
    }

    public String getServerBaseURL() {
        if (80 != this.getPort()) {
            return "http://" + this.getHost() + ":" + this.getPort();
        }
        return "http://" + this.getHost();
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        String host = "localhost";
        Connector[] connectors = this.jettyServer.getConnectors();
        if (connectors.length > 0 && connectors[0] instanceof SelectChannelConnector && connectors[0].getHost() != null) {
            host = connectors[0].getHost();
        }
        return host;
    }

    public Server getInternalJettyServer() {
        return this.jettyServer;
    }

    public void setHandler(HandlerList handlers) {
        if (this.isRunning() || this.isStarted()) {
            this.stop();
        }
        if (handlers != null) {
            this.jettyServer.setHandler((Handler)handlers);
        }
    }

    public void addHandler(String contextPath, String deployPath, boolean startServer) {
        if (this.contextPathMap.containsKey(contextPath)) {
            return;
        }
        if (this.isRunning() || this.isStarted()) {
            this.stop();
        }
        if (this.jettyServer.getHandler() instanceof ContextHandlerCollection) {
            WebAppContext webappHandler = new WebAppContext();
            webappHandler.setContextPath(contextPath);
            webappHandler.setResourceBase(deployPath);
            webappHandler.setParentLoaderPriority(true);
            webappHandler.getInitParams().put("useFileMappedBuffer", "false");
            ContextHandlerCollection contextCol = (ContextHandlerCollection)this.jettyServer.getHandler();
            contextCol.addHandler((Handler)webappHandler);
            this.contextPathMap.put(contextPath, deployPath);
        }
        if (startServer) {
            this.start();
        }
    }

    public String getState() {
        return this.jettyServer.getState();
    }

    public boolean isRunning() {
        return this.jettyServer.isRunning();
    }

    public boolean isStopped() {
        return this.jettyServer.isStopped();
    }

    public boolean isStarted() {
        return this.jettyServer.isStarted();
    }

    public boolean isStarting() {
        return this.jettyServer.isStarting();
    }

    public boolean isStopping() {
        return this.jettyServer.isStopping();
    }

    public boolean isFailed() {
        return this.jettyServer.isFailed();
    }

    public HashMap<String, String> getContextPathMap() {
        return this.contextPathMap;
    }
}

