/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jshint.engine;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.tizen.web.jshint.JsHintValidatorHelper;
import org.tizen.web.jshint.engine.Issue;
import org.tizen.web.jshint.engine.JsHintBuilder;
import org.tizen.web.jshint.engine.JsHintResult;
import org.tizen.web.jshint.engine.Option;
import org.tizen.web.jshint.engine.OptionParser;
import org.tizen.web.jshint.engine.Util;

public class JsHint {
    private final Map<Option, Object> options = new EnumMap<Option, Object>(Option.class);
    private final ContextFactory contextFactory;
    private final Function lintFunc;
    protected static final JsHint instance = new JsHintBuilder().fromDefault();

    public static JsHint getInstance() {
        return instance;
    }

    JsHint(ContextFactory contextFactory, Function lintFunc) {
        this.contextFactory = contextFactory;
        this.lintFunc = lintFunc;
    }

    public void addOption(Option o) {
        this.options.put(o, Boolean.TRUE);
    }

    public void addOption(Option o, String arg) {
        OptionParser optionParser = new OptionParser();
        this.options.put(o, optionParser.parse(o.getType(), arg));
    }

    private JsHintResult doLint(final String javaScript) {
        return (JsHintResult)this.contextFactory.call(new ContextAction(){

            public JsHintResult run(Context cx) {
                String src = javaScript == null ? "" : javaScript;
                Object[] args = new Object[]{src, JsHint.this.optionsAsJavaScriptObject(), JsHint.this.optionsAsGlobalObject()};
                JsHint.this.lintFunc.call(cx, (Scriptable)JsHint.this.lintFunc, null, args);
                NativeArray nativeList = (NativeArray)JsHint.this.lintFunc.get("errors", (Scriptable)JsHint.this.lintFunc);
                ArrayList<Issue> issueList = new ArrayList<Issue>();
                int i = 0;
                while ((long)i < nativeList.getLength()) {
                    Object obj = nativeList.get(i);
                    if (obj instanceof NativeObject) {
                        NativeObject nativeObj = (NativeObject)obj;
                        Object line = nativeObj.get((Object)"line");
                        Object character = nativeObj.get((Object)"character");
                        Object reason = nativeObj.get((Object)"reason");
                        if (line != null && character != null && reason != null) {
                            int row = 0;
                            if (line instanceof Integer) {
                                row = (Integer)line;
                            } else if (line instanceof Double) {
                                row = ((Double)line).intValue();
                            }
                            int column = 0;
                            if (character instanceof Integer) {
                                column = (Integer)character;
                            } else if (character instanceof Double) {
                                column = ((Double)character).intValue();
                            }
                            Issue issue = new Issue(row, column, reason.toString());
                            issueList.add(issue);
                        }
                    }
                    ++i;
                }
                return new JsHintResult(issueList);
            }
        });
    }

    public JsHintResult lint(String systemId, Reader reader) throws IOException {
        return this.lint(systemId, Util.readerToString(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsHintResult lint(String systemId, String javaScript) {
        JsHint jsHint = this;
        synchronized (jsHint) {
            return this.doLint(javaScript);
        }
    }

    private Scriptable optionsAsJavaScriptObject() {
        return (Scriptable)this.contextFactory.call(new ContextAction(){

            public Object run(Context cx) {
                Scriptable opts = cx.newObject((Scriptable)JsHint.this.lintFunc);
                for (Map.Entry entry : JsHint.this.options.entrySet()) {
                    String key = ((Option)((Object)entry.getKey())).getLowerName();
                    Object value = Util.javaToJS(entry.getValue(), opts);
                    opts.put(key, opts, value);
                }
                return opts;
            }
        });
    }

    private Scriptable optionsAsGlobalObject() {
        return (Scriptable)this.contextFactory.call(new ContextAction(){

            public Scriptable run(Context cx) {
                Scriptable opts = cx.newObject((Scriptable)JsHint.this.lintFunc);
                String[] stringArray = JsHintValidatorHelper.getPredefinedGlobalVariables();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String globalVariable = stringArray[n2];
                    opts.put(globalVariable, opts, (Object)true);
                    ++n2;
                }
                return opts;
            }
        });
    }

    public void resetOptions() {
        this.options.clear();
    }
}

