/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.tizen.web.editor.html.refactoring.WebFileDeleteChange;
import org.tizen.web.editor.html.refactoring.WebFileRefactoringConstants;

public class WebFileDeleteParticipant
extends DeleteParticipant
implements WebFileRefactoringConstants {
    private IFile srcFile = null;
    private String fileName = null;
    private IPath resourcePath = null;

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            boolean isImage;
            this.srcFile = (IFile)element;
            String extension = this.srcFile.getFileExtension();
            if (extension == null || extension.trim().equals("")) {
                return false;
            }
            WebFileRefactoringConstants.FileExtension fileExtension = WebFileRefactoringConstants.FileExtension.getFileExtension(extension = extension.toLowerCase());
            if (fileExtension == null && (isImage = (fileExtension = WebFileRefactoringConstants.FileExtension.UNKNOWN).isImage(extension))) {
                fileExtension = WebFileRefactoringConstants.FileExtension.IMAGE;
            }
            switch (fileExtension) {
                case HTML: 
                case HTM: 
                case JS: 
                case CSS: 
                case IMAGE: {
                    this.srcFile = (IFile)element;
                    this.resourcePath = ((IFile)element).getFullPath();
                    this.fileName = this.srcFile.getName();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String getName() {
        return "tizen-web-file-delete-refactoring";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new WebFileDeleteChange(this.resourcePath, this.srcFile, this.fileName, true);
    }
}

