/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.tizen.web.editor.html.refactoring.WebFileMoveChange;
import org.tizen.web.editor.html.refactoring.WebFileRefactoringConstants;

public class WebFileMoveParticipant
extends MoveParticipant
implements WebFileRefactoringConstants {
    private IFile srcFile = null;
    private IContainer target = null;

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            boolean isImage;
            String extension = ((IFile)element).getFileExtension();
            if (extension == null || extension.trim().equals("")) {
                return false;
            }
            WebFileRefactoringConstants.FileExtension fileExtension = WebFileRefactoringConstants.FileExtension.getFileExtension(extension = extension.toLowerCase());
            if (fileExtension == null && (isImage = (fileExtension = WebFileRefactoringConstants.FileExtension.UNKNOWN).isImage(extension))) {
                fileExtension = WebFileRefactoringConstants.FileExtension.IMAGE;
            }
            switch (fileExtension) {
                case HTML: 
                case HTM: 
                case JS: 
                case CSS: 
                case IMAGE: {
                    this.srcFile = (IFile)element;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String getName() {
        return "tizen-web-file-rename-refactoring";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        this.target = (IContainer)this.getArguments().getDestination();
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new WebFileMoveChange((IResource)this.srcFile, this.target);
    }
}

