/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.refactoring;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.wst.html.core.internal.document.DOMStyleModelImpl;
import org.eclipse.wst.html.core.internal.document.DocumentStyleImpl;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.editor.Activator;
import org.tizen.web.editor.contentassist.WebResourceManager;
import org.tizen.web.editor.html.refactoring.WebFileRefactoringConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.NodeList;

public class WebFileRenameChange
extends RenameResourceChange
implements WebFileRefactoringConstants {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String oldName = null;
    private String newName = null;
    private IPath resourcePath = null;
    private IFile srcFile = null;
    private Map<String, IResource> htmlFiles = null;

    public WebFileRenameChange(IPath resourcePath, IFile srcFile, String oldName, String newName) {
        super(resourcePath, newName);
        this.oldName = oldName;
        this.newName = newName;
        this.resourcePath = resourcePath;
        this.srcFile = srcFile;
        IProject project = this.srcFile.getProject();
        WebResourceManager resourceManager = new WebResourceManager(project);
        resourceManager.makeProjectManagedResourceMap();
        this.htmlFiles = resourceManager.getHtmlFiles();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        this.refactoring(pm);
        IPath renamedResourcePath = this.renamedResourcePath(this.resourcePath, this.newName);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(renamedResourcePath);
        return new WebFileRenameChange(renamedResourcePath, file, this.newName, this.oldName);
    }

    private IPath renamedResourcePath(IPath path, String newName) {
        return path.removeLastSegments(1).append(newName);
    }

    private void refactoring(IProgressMonitor monitor) {
        String extension = this.srcFile.getFileExtension();
        WebFileRefactoringConstants.FileExtension fileExtension = WebFileRefactoringConstants.FileExtension.getFileExtension(extension);
        if (fileExtension == null) {
            fileExtension = WebFileRefactoringConstants.FileExtension.IMAGE;
        }
        if (fileExtension == WebFileRefactoringConstants.FileExtension.HTML || fileExtension == WebFileRefactoringConstants.FileExtension.HTM) {
            IProject project = this.srcFile.getProject();
            WebResourceManager resourceManager = new WebResourceManager(project);
            resourceManager.makeProjectManagedResourceMap();
            this.htmlFiles = resourceManager.getHtmlFiles();
        }
        WebResourceManager.checkLocaleResources((IResource)this.srcFile, this.htmlFiles.entrySet().iterator());
        for (Map.Entry<String, IResource> fileEntry : this.htmlFiles.entrySet()) {
            IFile file = (IFile)fileEntry.getValue();
            try {
                IModelManager modelManager = StructuredModelManager.getModelManager();
                IStructuredModel model = modelManager.getModelForEdit(file);
                if (model == null) continue;
                DOMStyleModelImpl dom = (DOMStyleModelImpl)model;
                IDOMDocument document = dom.getDocument();
                this.refactoring(file, fileExtension, document);
                IStructuredDocument structuredDocument = model.getStructuredDocument();
                modelManager.saveStructuredDocument(structuredDocument, file);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void refactoring(IFile file, WebFileRefactoringConstants.FileExtension fileExtension, IDOMDocument document) {
        String tagName = null;
        String attributeName = null;
        switch (fileExtension) {
            case HTML: 
            case HTM: {
                tagName = "a";
                attributeName = "href";
                this.processRefactoring(file, document, tagName, attributeName);
                tagName = "iframe";
                attributeName = "src";
                this.processRefactoring(file, document, tagName, attributeName);
                break;
            }
            case CSS: {
                tagName = "link";
                attributeName = "href";
                this.processRefactoring(file, document, tagName, attributeName);
                break;
            }
            case JS: {
                tagName = "script";
                attributeName = "src";
                this.processRefactoring(file, document, tagName, attributeName);
                break;
            }
            case IMAGE: {
                tagName = "img";
                attributeName = "src";
                this.processRefactoring(file, document, tagName, attributeName);
                break;
            }
        }
    }

    private void processRefactoring(IFile file, IDOMDocument document, String tagName, String attributeName) {
        NodeList nodeList = ((DocumentStyleImpl)document).getElementsByTagName(tagName);
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                String attribute;
                ElementStyleImpl element = (ElementStyleImpl)nodeList.item(i);
                Attr attributeNode = element.getAttributeNode(attributeName);
                if (attributeNode != null && (attribute = element.getAttribute(attributeName)).contains(this.oldName)) {
                    attribute = attribute.replace(this.oldName, this.newName);
                    attributeNode.setNodeValue(attribute);
                    IStructuredDocumentRegion startStructuredDocumentRegion = element.getStartStructuredDocumentRegion();
                    int start = startStructuredDocumentRegion.getStart();
                    IStructuredDocument parentDocument = startStructuredDocumentRegion.getParentDocument();
                    int lineOfOffset = parentDocument.getLineOfOffset(start) + 1;
                    this.print(file, "[RENAME REFACTOR] " + file.getName() + "(" + lineOfOffset + ")" + " is changed at '" + startStructuredDocumentRegion.getFullText() + "'.");
                }
                ++i;
            }
        }
    }

    private void print(IFile file, String message) {
        try {
            MessageConsole refactorConsole = Activator.getDefault().getRefactorConsole();
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{refactorConsole});
            ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)refactorConsole);
            MessageConsoleStream stream = refactorConsole.newMessageStream();
            stream.setActivateOnWrite(true);
            stream.println(message);
            stream.close();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

