/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css1;

import java.util.Arrays;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;

public class CssFontSize
extends org.w3c.css.properties.css.CssFontSize {
    public static final CssIdent[] allowed_values;
    static final String[] absolute_values;
    static final String[] relative_values;

    public static CssIdent getAllowedValue(CssIdent ident) {
        int idx = Arrays.binarySearch(allowed_values, ident);
        if (idx >= 0) {
            return allowed_values[idx];
        }
        return null;
    }

    public CssFontSize() {
    }

    public CssFontSize(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        switch (val.getType()) {
            case 5: {
                val = ((CssNumber)val).getLength();
            }
            case 6: {
                CssLength l = (CssLength)val;
                if (!l.isPositive()) {
                    throw new InvalidParamException("negative-value", val.toString(), ac);
                }
                this.value = l;
                break;
            }
            case 4: {
                CssPercentage p = (CssPercentage)val;
                if (!p.isPositive()) {
                    throw new InvalidParamException("negative-value", val.toString(), ac);
                }
                this.value = p;
                break;
            }
            case 0: {
                this.value = CssFontSize.getAllowedValue((CssIdent)val);
                if (this.value != null) break;
                throw new InvalidParamException("value", expression.getValue().toString(), this.getPropertyName(), ac);
            }
            default: {
                throw new InvalidParamException("value", expression.getValue().toString(), this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    public CssFontSize(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        absolute_values = new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large"};
        relative_values = new String[]{"smaller", "larger"};
        allowed_values = new CssIdent[absolute_values.length + relative_values.length];
        int i = 0;
        for (String s : absolute_values) {
            CssFontSize.allowed_values[i++] = CssIdent.getIdent(s);
        }
        for (String s : relative_values) {
            CssFontSize.allowed_values[i++] = CssIdent.getIdent(s);
        }
        Arrays.sort(allowed_values);
    }
}

