/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css1;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css1.CssPaddingBottom;
import org.w3c.css.properties.css1.CssPaddingLeft;
import org.w3c.css.properties.css1.CssPaddingRight;
import org.w3c.css.properties.css1.CssPaddingTop;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssPadding
extends org.w3c.css.properties.css.CssPadding {
    public CssPadding() {
    }

    public CssPadding(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssPadding(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        ArrayList<CssValue> v = new ArrayList<CssValue>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: 
                case 6: {
                    CssLength l = val.getLength();
                    l.checkPositiveness(ac, this);
                    v.add(val);
                    break;
                }
                case 4: {
                    CssPercentage p = val.getPercentage();
                    p.checkPositiveness(ac, this);
                    v.add(val);
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", new Character(op).toString(), ac);
            }
            expression.next();
        }
        this.paddingBottom = new CssPaddingBottom();
        this.paddingLeft = new CssPaddingLeft();
        this.paddingTop = new CssPaddingTop();
        this.paddingRight = new CssPaddingRight();
        switch (v.size()) {
            case 1: {
                this.paddingTop.value = (CssValue)v.get(0);
                this.paddingRight.value = (CssValue)v.get(0);
                this.paddingBottom.value = (CssValue)v.get(0);
                this.paddingLeft.value = (CssValue)v.get(0);
                break;
            }
            case 2: {
                this.paddingTop.value = (CssValue)v.get(0);
                this.paddingRight.value = (CssValue)v.get(1);
                this.paddingBottom.value = (CssValue)v.get(0);
                this.paddingLeft.value = (CssValue)v.get(1);
                break;
            }
            case 3: {
                this.paddingTop.value = (CssValue)v.get(0);
                this.paddingRight.value = (CssValue)v.get(1);
                this.paddingBottom.value = (CssValue)v.get(2);
                this.paddingLeft.value = (CssValue)v.get(1);
                break;
            }
            case 4: {
                this.paddingTop.value = (CssValue)v.get(0);
                this.paddingRight.value = (CssValue)v.get(1);
                this.paddingBottom.value = (CssValue)v.get(2);
                this.paddingLeft.value = (CssValue)v.get(3);
                break;
            }
            default: {
                throw new InvalidParamException("unrecognize", ac);
            }
        }
        this.value = new CssValueList(v);
    }

    protected static CssValue checkValue(ApplContext ac, CssExpression expression, boolean check2, CssProperty caller) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        switch (val.getType()) {
            case 5: 
            case 6: {
                CssLength l = val.getLength();
                l.checkPositiveness(ac, caller);
                expression.next();
                return val;
            }
            case 4: {
                CssPercentage p = val.getPercentage();
                p.checkPositiveness(ac, caller);
                expression.next();
                return val;
            }
        }
        throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
    }
}

