/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css2.user;

import java.util.ArrayList;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css2.user.Css2Style;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssValue;

public class Cursor
extends CssProperty
implements CssOperator {
    int value;
    ArrayList<CssValue> uris = new ArrayList();
    boolean inheritedValue;
    private static String[] CURSOR = new String[]{"auto", "crosshair", "default", "pointer", "move", "e-resize", "ne-resize", "nw-resize", "n-resize", "se-resize", "sw-resize", "s-resize", "w-resize", "text", "wait", "help", "progress", "copy", "alias", "context-menu", "cell", "all-scroll", "col-resize", "row-resize", "no-drop", "not-allowed", "vertical-text"};
    private static int[] hash_values = new int[CURSOR.length];

    public Cursor() {
        this.value = 0;
    }

    public Cursor(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        this.setByUser();
        if (val.equals(inherit)) {
            if (expression.getCount() > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            this.inheritedValue = true;
            expression.next();
            return;
        }
        while (op == ',' && val.getType() == 2) {
            if (val != null && val.equals(inherit)) {
                throw new InvalidParamException("unrecognize", ac);
            }
            this.uris.add(val);
            expression.next();
            val = expression.getValue();
            op = expression.getOperator();
        }
        if (val.getType() == 2) {
            throw new InvalidParamException("comma", val.toString(), this.getPropertyName(), ac);
        }
        if (val.getType() == 0) {
            int hash = val.hashCode();
            for (int i = 0; i < CURSOR.length; ++i) {
                if (hash_values[i] != hash) continue;
                this.value = i;
                expression.next();
                if (check2 && !expression.end()) {
                    throw new InvalidParamException("unrecognize", ac);
                }
                return;
            }
        }
        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
    }

    public Cursor(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public Object get() {
        return null;
    }

    @Override
    public String getPropertyName() {
        return "cursor";
    }

    @Override
    public boolean isSoftlyInherited() {
        return this.inheritedValue;
    }

    @Override
    public String toString() {
        if (this.inheritedValue) {
            return inherit.toString();
        }
        StringBuilder ret = new StringBuilder();
        for (CssValue val : this.uris) {
            ret.append(val).append(',').append(' ');
        }
        ret.append(' ').append(CURSOR[this.value]);
        return ret.toString();
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        Css2Style style0 = (Css2Style)style;
        if (style0.cursor != null) {
            style0.addRedefinitionWarning(ac, this);
        }
        style0.cursor = this;
    }

    @Override
    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css2Style)style).getCursor();
        }
        return ((Css2Style)style).cursor;
    }

    @Override
    public boolean equals(CssProperty property) {
        return property instanceof Cursor && this.value == ((Cursor)property).value;
    }

    @Override
    public boolean isDefault() {
        return this.value == 0;
    }

    static {
        for (int i = 0; i < CURSOR.length; ++i) {
            Cursor.hash_values[i] = CURSOR[i].hashCode();
        }
    }
}

