/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css3.CssTransitionDelay;
import org.w3c.css.properties.css3.CssTransitionDuration;
import org.w3c.css.properties.css3.CssTransitionProperty;
import org.w3c.css.properties.css3.CssTransitionTimingFunction;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssTransition
extends org.w3c.css.properties.css.CssTransition {
    CssTransitionProperty cssTransitionProperty = null;
    CssTransitionTimingFunction cssTransitionTimingFunction = null;
    CssTransitionDelay cssTransitionDelay = null;
    CssTransitionDuration cssTransitionDuration = null;

    public CssTransition() {
        this.value = initial;
        this.cssTransitionDelay = new CssTransitionDelay();
        this.cssTransitionDuration = new CssTransitionDuration();
        this.cssTransitionProperty = new CssTransitionProperty();
        this.cssTransitionTimingFunction = new CssTransitionTimingFunction();
    }

    public CssTransition(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.setByUser();
        CssExpression single_layer = null;
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (inherit.equals(val)) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                this.value = inherit;
                expression.next();
                return;
            }
            if (single_layer == null) {
                single_layer = new CssExpression();
            }
            single_layer.addValue(val);
            single_layer.setOperator(op);
            expression.next();
            if (expression.end()) continue;
            if (op == ',') {
                single_layer.setOperator(' ');
                values.add(this.checkLayer(ac, single_layer, this));
                single_layer = null;
                continue;
            }
            if (op == ' ') continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        if (single_layer != null) {
            values.add(this.checkLayer(ac, single_layer, this));
        }
        if (values.size() == 1) {
            this.value = (CssValue)values.get(0);
            CssTransitionValue v = (CssTransitionValue)this.value;
            if (v.delay != null) {
                this.cssTransitionDelay = new CssTransitionDelay();
                this.cssTransitionDelay.value = v.delay;
            }
            if (v.duration != null) {
                this.cssTransitionDuration = new CssTransitionDuration();
                this.cssTransitionDuration.value = v.duration;
            }
            if (v.property != null) {
                this.cssTransitionProperty = new CssTransitionProperty();
                this.cssTransitionProperty.value = v.property;
            }
            if (v.timingfunc != null) {
                this.cssTransitionTimingFunction = new CssTransitionTimingFunction();
                this.cssTransitionTimingFunction.value = v.timingfunc;
            }
        } else {
            for (CssValue tv : values) {
                CssTransitionValue rtv = (CssTransitionValue)tv;
                if (rtv.property != none) continue;
                throw new InvalidParamException("value", none, this.getPropertyName(), ac);
            }
            this.value = new CssLayerList(values);
        }
    }

    public CssTransition(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        super.addToStyle(ac, style);
        if (this.cssTransitionDelay != null) {
            this.cssTransitionDelay.addToStyle(ac, style);
        }
        if (this.cssTransitionDuration != null) {
            this.cssTransitionDuration.addToStyle(ac, style);
        }
        if (this.cssTransitionProperty != null) {
            this.cssTransitionProperty.addToStyle(ac, style);
        }
        if (this.cssTransitionTimingFunction != null) {
            this.cssTransitionTimingFunction.addToStyle(ac, style);
        }
    }

    private CssTransitionValue checkLayer(ApplContext ac, CssExpression expression, CssProperty caller) throws InvalidParamException {
        CssTransitionValue v = new CssTransitionValue();
        if (expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        while (!expression.end()) {
            CssValue val = expression.getValue();
            switch (val.getType()) {
                case 8: {
                    if (v.duration == null) {
                        CssTime t = val.getTime();
                        t.warnPositiveness(ac, this);
                        v.duration = val;
                        break;
                    }
                    if (v.delay == null) {
                        v.delay = val;
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
                case 12: {
                    if (v.timingfunc == null) {
                        CssTransitionTimingFunction.parseFunctionValues(ac, val, this);
                        v.timingfunc = val;
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
                case 0: {
                    CssIdent match;
                    CssIdent ident = (CssIdent)val;
                    if (inherit.equals(ident)) {
                        if (expression.getCount() != 1) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        v.property = inherit;
                        break;
                    }
                    if (v.timingfunc == null && (match = CssTransitionTimingFunction.getAllowedIdent(ident)) != null) {
                        v.timingfunc = match;
                        break;
                    }
                    if (v.property == null) {
                        v.property = CssTransitionProperty.getAllowedIdent(ac, ident);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
            }
            expression.next();
        }
        return v;
    }

    private class CssTransitionValue
    extends CssValueList {
        CssValue delay = null;
        CssValue duration = null;
        CssValue property = null;
        CssValue timingfunc = null;

        private CssTransitionValue() {
        }

        @Override
        public String toString() {
            boolean doneFirst = false;
            StringBuilder sb = new StringBuilder();
            if (this.property != null) {
                sb.append(this.property);
                doneFirst = true;
            }
            if (this.duration != null) {
                if (doneFirst) {
                    sb.append(' ');
                }
                sb.append(this.duration);
                doneFirst = true;
                if (this.delay != null) {
                    sb.append(' ').append(this.delay);
                }
            }
            if (this.timingfunc != null) {
                if (doneFirst) {
                    sb.append(' ');
                }
                sb.append(this.timingfunc);
            }
            return sb.toString();
        }
    }
}

