/*
 * Decompiled with CFR 0.152.
 */
package io.emmet;

import io.emmet.IEmmetEditor;
import io.emmet.IUserData;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.IOUtil;

public class Emmet {
    private static volatile Emmet singleton;
    private static Context cx;
    private static Scriptable scope;
    private static String snippetsJSON;
    private static IUserData userDataDelegate;
    private final Logger logger;
    private static String[] coreFiles;

    static {
        snippetsJSON = "snippets.json";
        userDataDelegate = null;
        coreFiles = new String[]{"emmet-app.js", "file-interface.js", "java-wrapper.js"};
    }

    private Emmet() {
        block8: {
            this.logger = LoggerFactory.getLogger(this.getClass());
            cx = Context.enter();
            scope = cx.initStandardObjects();
            InputStreamReader isr = null;
            try {
                try {
                    String[] addons;
                    String[] jsSource = (String[])coreFiles.clone();
                    if (userDataDelegate != null && (addons = userDataDelegate.additionalSourceJS()) != null) {
                        System.arraycopy(addons, 0, jsSource, jsSource.length, addons.length);
                    }
                    int i = 0;
                    while (i < jsSource.length) {
                        isr = this.getReaderForLocalFile(jsSource[i]);
                        cx.evaluateReader(scope, (Reader)isr, jsSource[i], 1, null);
                        ++i;
                    }
                    this.execJSFunction("javaLoadSystemSnippets", this.readLocalFile(snippetsJSON));
                    if (userDataDelegate != null) {
                        userDataDelegate.load(this);
                        userDataDelegate.loadExtensions(this);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    IOUtil.tryClose((Object[])new Object[]{isr});
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{isr});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{isr});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Emmet getSingleton() {
        if (singleton != null) return singleton;
        Class<Emmet> clazz = Emmet.class;
        synchronized (Emmet.class) {
            if (singleton != null) return singleton;
            singleton = new Emmet();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public static void setUserDataDelegate(IUserData delegate) {
        userDataDelegate = delegate;
    }

    public static void reset() {
        if (singleton == null) {
            return;
        }
        Context.exit();
        cx = null;
        scope = null;
        singleton = null;
    }

    private InputStreamReader getReaderForLocalFile(String fileName) {
        InputStream is = this.getClass().getResourceAsStream(fileName);
        return new InputStreamReader(is);
    }

    private String readLocalFile(String fileName) {
        String string;
        InputStream is = this.getClass().getResourceAsStream(fileName);
        try {
            string = new Scanner(is).useDelimiter("\\A").next();
        }
        catch (NoSuchElementException noSuchElementException) {
            try {}
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{is});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{is});
            return "";
        }
        IOUtil.tryClose((Object[])new Object[]{is});
        return string;
    }

    public Object execJSFunction(String name, Object ... vargs) {
        StringBuilder jsArgs = new StringBuilder();
        int i = 0;
        while (i < vargs.length) {
            Object wrappedObj = Context.javaToJS((Object)vargs[i], (Scriptable)scope);
            ScriptableObject.putProperty((Scriptable)scope, (String)("__javaParam" + i), (Object)wrappedObj);
            if (i > 0) {
                jsArgs.append(',');
            }
            jsArgs.append("__javaParam" + i);
            ++i;
        }
        Object result = cx.evaluateString(scope, String.valueOf(name) + "(" + jsArgs.toString() + ");", "<eval>", 1, null);
        int i2 = 0;
        while (i2 < vargs.length) {
            ScriptableObject.deleteProperty((Scriptable)scope, (String)("__javaParam" + i2));
            ++i2;
        }
        return result;
    }

    public boolean runAction(Object ... args) {
        return Context.toBoolean((Object)this.execJSFunction("runEmmetAction", args));
    }

    public String getWrapPreview(IEmmetEditor editor, String abbr) {
        return Context.toString((Object)this.execJSFunction("previewWrapWithAbbreviation", editor, abbr));
    }
}

