/*
 * Decompiled with CFR 0.152.
 */
package io.emmet.eclipse;

import io.emmet.IEmmetEditor;
import io.emmet.SelectionData;
import io.emmet.TabStop;
import io.emmet.TabStopGroup;
import io.emmet.TabStopStructure;
import io.emmet.eclipse.AutoCompleteDialog;
import io.emmet.eclipse.EclipseEmmetHelper;
import io.emmet.eclipse.EditorTypeInvestigator;
import io.emmet.eclipse.WrapWithAbbreviationDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class EclipseEmmetEditor
implements IEmmetEditor {
    private IEditorPart editor;
    private IDocument doc;
    private String caretPlaceholder = "${0}";
    private static Pattern whitespaceBegin = Pattern.compile("^(\\s+)");
    private static String DIALOG_PROMPT = "prompt";
    private static String DIALOG_WRAP_WITH_ABBREVIATION = "wrap";
    private HashMap<String, ArrayList<String>> proposals;

    public EclipseEmmetEditor() {
    }

    public EclipseEmmetEditor(IEditorPart editor) {
        this.setContext(editor);
    }

    public void setContext(IEditorPart editor) {
        this.editor = editor;
        this.doc = EclipseEmmetHelper.getDocument(editor);
        if (this.proposals == null) {
            this.proposals = new HashMap();
        }
    }

    public boolean isValid() {
        return this.editor != null && this.doc != null;
    }

    @Override
    public SelectionData getSelectionRange() {
        ISelectionProvider sp = this.editor.getEditorSite().getSelectionProvider();
        ISelection selection = sp.getSelection();
        SelectionData result = new SelectionData();
        if (selection instanceof ITextSelection) {
            ITextSelection txSel = (ITextSelection)selection;
            result.updateRangeWithLength(txSel.getOffset(), txSel.getLength());
        }
        return result;
    }

    @Override
    public void createSelection(int start, int end) {
        this.editor.getEditorSite().getSelectionProvider().setSelection((ISelection)new TextSelection(start, end - start));
    }

    @Override
    public SelectionData getCurrentLineRange() {
        return this.getLineRangeFromPosition(this.getCaretPos());
    }

    public SelectionData getLineRangeFromPosition(int pos) {
        SelectionData result = new SelectionData();
        try {
            IRegion lineInfo = this.doc.getLineInformationOfOffset(pos);
            result.updateRangeWithLength(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {}
        return result;
    }

    @Override
    public int getCaretPos() {
        return this.getSelectionRange().getStart();
    }

    @Override
    public void setCaretPos(int pos) {
        this.createSelection(pos, pos);
    }

    @Override
    public String getCurrentLine() {
        return this.getLineFromRange(this.getCurrentLineRange());
    }

    public String getLineFromRange(SelectionData range) {
        try {
            return this.doc.get(range.getStart(), range.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    @Override
    public void replaceContent(String value) {
        this.replaceContent(value, 0, this.doc.getLength(), false);
    }

    @Override
    public void replaceContent(String value, int start) {
        this.replaceContent(value, start, start, false);
    }

    @Override
    public void replaceContent(String value, int start, int end) {
        this.replaceContent(value, start, end, false);
    }

    @Override
    public void replaceContent(String value, int start, int end, boolean noIndent) {
        String newValue = value;
        if (!noIndent) {
            String line = this.getLineFromRange(this.getLineRangeFromPosition(start));
            String padding = this.getStringPadding(line);
            newValue = this.padString(value, padding);
        }
        TabStopStructure tabStops = new TabStopStructure(newValue);
        newValue = tabStops.getText();
        try {
            this.doc.replace(start, end - start, newValue);
            int totalLinks = tabStops.getTabStopsCount();
            if (totalLinks < 1) {
                tabStops.addTabStopToGroup("carets", newValue.length(), newValue.length());
            }
            String[] tabGroups = tabStops.getSortedGroupKeys();
            TabStop firstTabStop = tabStops.getFirstTabStop();
            if (totalLinks > 1 || firstTabStop != null && firstTabStop.getStart() != firstTabStop.getEnd()) {
                ITextViewer viewer = EclipseEmmetHelper.getTextViewer(this.editor);
                LinkedModeModel model = new LinkedModeModel();
                int exitPos = -1;
                int i = 0;
                while (i < tabGroups.length) {
                    TabStopGroup tabGroup = tabStops.getTabStopGroup(tabGroups[i]);
                    LinkedPositionGroup group = null;
                    if (tabGroups[i].equals("carets") || tabGroups[i].equals("0")) {
                        int caretCount = tabGroup.getTabStopList().size();
                        int j = 0;
                        while (j < caretCount) {
                            TabStop ts = tabGroup.getTabStopList().get(j);
                            group = new LinkedPositionGroup();
                            group.addPosition(new LinkedPosition(this.doc, start + ts.getStart(), ts.getLength()));
                            model.addGroup(group);
                            if (j == caretCount - 1) {
                                exitPos = start + ts.getStart();
                            }
                            ++j;
                        }
                    } else {
                        group = new LinkedPositionGroup();
                        int j = 0;
                        while (j < tabGroup.getTabStopList().size()) {
                            TabStop ts = tabGroup.getTabStopList().get(j);
                            group.addPosition(new LinkedPosition(this.doc, start + ts.getStart(), ts.getLength()));
                            ++j;
                        }
                        model.addGroup(group);
                    }
                    ++i;
                }
                model.forceInstall();
                LinkedModeUI linkUI = new LinkedModeUI(model, viewer);
                if (exitPos != -1) {
                    linkUI.setExitPosition(viewer, exitPos, 0, Integer.MAX_VALUE);
                }
                linkUI.setSimpleMode(this.isApatana());
                linkUI.enter();
            } else if (firstTabStop != null) {
                this.setCaretPos(start + firstTabStop.getStart());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCurrentLinePadding() {
        return this.getStringPadding(this.getCurrentLine());
    }

    private String getStringPadding(String text) {
        Matcher matcher = whitespaceBegin.matcher(text);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return "";
    }

    public String repeatString(String str, int howMany) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < howMany) {
            result.append(str);
            ++i;
        }
        return result.toString();
    }

    public String getNewline() {
        return TextUtilities.getDefaultLineDelimiter((IDocument)this.doc);
    }

    public String padString(String text, String pad) {
        StringBuilder result = new StringBuilder();
        String newline = this.getNewline();
        String[] lines = text.split("\\r\\n|\\n\\r|\\r|\\n", -1);
        if (lines.length > 0) {
            result.append(lines[0]);
            int i = 1;
            while (i < lines.length) {
                result.append(String.valueOf(newline) + pad + lines[i]);
                ++i;
            }
        } else {
            result.append(text);
        }
        return result.toString();
    }

    @Override
    public String getContent() {
        return this.doc.get();
    }

    @Override
    public String getSyntax() {
        String syntax = EditorTypeInvestigator.getSyntax(this);
        if (syntax == null) {
            syntax = EditorTypeInvestigator.TYPE_HTML;
        }
        return syntax;
    }

    @Override
    public String getProfileName() {
        return null;
    }

    public String prompt(String type, String title) {
        final Display currentDisplay = Display.getCurrent();
        String defaultValueArg = "";
        final String message = title;
        final String dialogType = type;
        final String defaultValue = defaultValueArg;
        class Answer {
            public String result = "";

            Answer() {
            }
        }
        final Answer a = new Answer();
        if (currentDisplay != null) {
            currentDisplay.syncExec(new Runnable(){
                {
                }

                @Override
                public void run() {
                    Shell shell = currentDisplay.getActiveShell();
                    if (shell != null) {
                        AutoCompleteDialog dialog = EclipseEmmetEditor.this.dialogFactory(dialogType, message, defaultValue);
                        int dialogResult = dialog.open();
                        if (dialogResult == 0) {
                            a.result = dialog.getValue();
                            EclipseEmmetEditor.this.addProposal(message, a.result);
                        } else {
                            a.result = "";
                        }
                    }
                }
            });
        }
        return a.result;
    }

    @Override
    public String prompt(String title) {
        return this.prompt(DIALOG_PROMPT, title);
    }

    public String promptWrap(String title) {
        return this.prompt(DIALOG_WRAP_WITH_ABBREVIATION, title);
    }

    private AutoCompleteDialog dialogFactory(String type, String message, String defaultValue) {
        AutoCompleteDialog dialog = DIALOG_WRAP_WITH_ABBREVIATION.equalsIgnoreCase(type) ? new WrapWithAbbreviationDialog(null, "Emmet Prompt", message, defaultValue) : new AutoCompleteDialog(null, "Emmet Prompt", message, defaultValue);
        dialog.setProposals(this.getProposals(message));
        return dialog;
    }

    private ArrayList<String> getProposals(String title) {
        if (this.proposals.containsKey(title)) {
            return this.proposals.get(title);
        }
        return null;
    }

    private void addProposal(String title, String value) {
        if (!value.equals("")) {
            ArrayList<String> props;
            if (!this.proposals.containsKey(title)) {
                this.proposals.put(title, new ArrayList());
            }
            if (!(props = this.proposals.get(title)).contains(value)) {
                props.add(0, value);
            }
        }
    }

    @Override
    public String getSelection() {
        SelectionData selection = this.getSelectionRange();
        try {
            return this.doc.get(selection.getStart(), selection.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    @Override
    public String getFilePath() {
        String uri = EclipseEmmetHelper.getURI(this.editor);
        if (uri != null) {
            uri = uri.substring(5);
        }
        return uri;
    }

    public IEditorPart getEditor() {
        return this.editor;
    }

    public IDocument getDocument() {
        return this.doc;
    }

    public String getCaretPlaceholder() {
        return this.caretPlaceholder;
    }

    public boolean isApatana() {
        return this.getEditor().toString().toLowerCase().indexOf(".aptana.") != -1;
    }

    public void print(String msg) {
        System.out.println("ZC: " + msg);
    }

    public String cleanText(String text) {
        TabStopStructure tss = new TabStopStructure(text);
        return tss.getText();
    }
}

