/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.csslint.engine;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;

final class Util {
    private Util() {
    }

    static boolean booleanValue(String name, Scriptable scope) {
        Object val = scope.get(name, scope);
        if (val == UniqueTag.NOT_FOUND) {
            return false;
        }
        return Context.toBoolean((Object)val);
    }

    static int intValue(String name, Scriptable scope) {
        if (scope == null) {
            return 0;
        }
        Object o = scope.get(name, scope);
        return o == Scriptable.NOT_FOUND ? 0 : (int)Context.toNumber((Object)o);
    }

    static Object javaToJS(Object o, Scriptable scope) {
        Class<?> cls = o.getClass();
        if (cls.isArray()) {
            return new NativeArray((Object[])o);
        }
        return Context.javaToJS((Object)o, (Scriptable)scope);
    }

    static <T> List<T> listValue(String name, Scriptable scope, Converter<T> c) {
        Object val = scope.get(name, scope);
        if (val == UniqueTag.NOT_FOUND || val instanceof Undefined) {
            return new ArrayList();
        }
        Scriptable ary = (Scriptable)val;
        int count = Util.intValue("length", ary);
        ArrayList<T> list = new ArrayList<T>(count);
        int i = 0;
        while (i < count) {
            list.add(c.convert(ary.get(i, ary)));
            ++i;
        }
        return list;
    }

    static <T> List<T> listValueOfType(String name, Class<T> class1, Scriptable scope) {
        return Util.listValue(name, scope, new Converter<T>(){

            @Override
            public T convert(Object obj) {
                Object value = obj;
                return value;
            }
        });
    }

    static String readerToString(Reader reader) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        while ((c = reader.read()) != -1) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    static String stringValue(String name, Scriptable scope) {
        if (scope == null) {
            return null;
        }
        Object o = scope.get(name, scope);
        return o instanceof String ? (String)o : null;
    }

    static interface Converter<T> {
        public T convert(Object var1);
    }
}

