/*
 * Decompiled with CFR 0.152.
 */
package json.outline.elements;

import java.util.LinkedList;
import java.util.List;
import json.outline.elements.JsonElement;
import json.outline.elements.JsonParent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class JsonObject
extends JsonElement
implements JsonParent {
    private String key;
    private static final String iconPath = "/icons/JsonObject.png";
    private List<JsonElement> values = new LinkedList<JsonElement>();

    public JsonObject(JsonParent parent) {
        super(parent);
    }

    public JsonObject(JsonParent parent, String key) {
        super(parent);
        this.key = key;
    }

    @Override
    public List<JsonElement> getChildren() {
        return this.values;
    }

    @Override
    public void removeFromParent() {
        if (this.getParent() != null) {
            this.getParent().removeEntry(this);
        }
    }

    @Override
    public void removeEntry(JsonElement jsonElement) {
        this.values.remove(jsonElement);
    }

    @Override
    public boolean hasChildren() {
        return !this.values.isEmpty();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<JsonElement> getValues() {
        return this.values;
    }

    public void setValues(List<JsonElement> values) {
        this.values = values;
    }

    @Override
    public void addChild(JsonElement jsonElement) {
        this.values.add(jsonElement);
    }

    public String toString() {
        return this.key;
    }

    @Override
    public Image getImage() {
        return this.createMyImage(iconPath);
    }

    @Override
    public String getForegroundColor() {
        return null;
    }

    @Override
    public StyledString getStyledString() {
        StyledString styledString = new StyledString();
        StyledString.Styler style1 = StyledString.createColorRegistryStyler((String)"GREEN", (String)"WHITE");
        styledString.append(this.key, style1);
        return styledString;
    }
}

