/*
 * Decompiled with CFR 0.152.
 */
package json.util.reader;

import json.util.JsonCharUtility;
import json.util.reader.JsonReader;
import json.util.reader.JsonReaderException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class JsonDocReader
implements JsonReader {
    private IDocument doc;
    private char previous;
    private char current;
    private int position;

    public JsonDocReader(IDocument doc) {
        this.doc = doc;
    }

    @Override
    public char getCurrent() {
        return this.current;
    }

    @Override
    public char getNextChar() throws JsonReaderException {
        char ch = this.next();
        this.previous = this.current;
        this.current = ch;
        return this.current;
    }

    private char next() throws JsonReaderException {
        try {
            if (this.position < this.doc.getLength()) {
                char ch = this.doc.getChar(this.position++);
                return ch;
            }
            return '\uffff';
        }
        catch (BadLocationException badLocationException) {
            throw new JsonReaderException();
        }
    }

    @Override
    public char getNextClean() throws JsonReaderException {
        char ch = ' ';
        while (JsonCharUtility.isWhiteSpace(ch)) {
            ch = this.next();
        }
        this.previous = this.current;
        this.current = ch;
        return this.current;
    }

    @Override
    public int getPosition() {
        return this.position - 1;
    }

    @Override
    public char getPrevious() {
        return this.previous;
    }
}

