#!/usr/bin/python3 -tt
#
# Marko Saukko <marko.saukko@cybercom.com>
#
# Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
#
# This copyrighted material is made available to anyone wishing to use, modify,
# copy, or redistribute it subject to the terms and conditions of the GNU
# General Public License v.2. This program is distributed in the hope that it
# will be useful, but WITHOUT ANY WARRANTY expressed or implied, including the
# implied warranties of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 51
# Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

from pykickstart.commands.partition import *

class Mic_PartData(FC4_PartData):
    removedKeywords = FC4_PartData.removedKeywords
    removedAttrs = FC4_PartData.removedAttrs

    def __init__(self, *args, **kwargs):
        FC4_PartData.__init__(self, *args, **kwargs)
        self.deleteRemovedAttrs()
        self.align = kwargs.get("align", None)
        self.extopts = kwargs.get("extopts", None)
        self.f2fsopts = kwargs.get("f2fsopts", None)
        self.part_type = kwargs.get("part_type", None)
        self.uuid = kwargs.get("uuid", None)
        self.exclude_image = kwargs.get("exclude_from_image", False)
        self.vdfsopts = kwargs.get("vdfsopts", None)
        self.squashfsopts = kwargs.get("squashfsopts", None)
        self.squashfsoptions_maxsize = kwargs.get("squashfsoptions_maxsize", None)
        self.erofsopts = kwargs.get("erofsopts", None)
        self.cpioopts = kwargs.get("cpioopts", None)
        self.no_shrink = kwargs.get("no_shrink", False)
        self.init_expand = kwargs.get("init_expand", False)

    def _getArgsAsStr(self):
        retval = FC4_PartData._getArgsAsStr(self)

        if self.align:
            retval += " --align"
        if self.extopts:
            retval += " --extoptions=%s" % self.extopts
        if self.f2fsopts:
            retval += " --f2fsoptions=%s" % self.f2fsopts
        if self.part_type:
            retval += " --part-type=%s" % self.part_type
        if self.uuid:
            retval += " --uuid=%s" % self.uuid
        if self.exclude_image:
            retval += " --exclude-from-image"
        if self.vdfsopts:
            retval += " --vdfsoptions=%s" % self.vdfsopts
        if self.squashfsopts:
            retval += " --squashfsoptions=%s" % self.squashfsopts
        if self.squashfsoptions_maxsize:
            retval += " --squashfsoptions_maxsize=%s" % self.squashfsoptions_maxsize
        if self.erofsopts:
            retval += " --erofsoptions=%s" % self.erofsopts
        if self.cpioopts:
            retval += " --cpiooptions=%s" % self.cpioopts
        if self.no_shrink:
            retval += " --no-shrink"
        if self.init_expand:
            retval += " --init-expand"
        return retval

class Mic_Partition(FC4_Partition):
    removedKeywords = FC4_Partition.removedKeywords
    removedAttrs = FC4_Partition.removedAttrs

    def _getParser(self):
        op = FC4_Partition._getParser(self)
        # The alignment value is given in kBytes. e.g., value 8 means that
        # the partition is aligned to start from 8096 byte boundary.
        op.add_argument("--align", type=int, action="store", dest="align",
                      default=None, version=FC4, help='align')
        op.add_argument("--extoptions", type=str, action="store", dest="extopts",
                      default=None, version=FC4, help='extoptions')
        op.add_argument("--f2fsoptions", type=str, action="store", dest="f2fsopts",
                      default=None, version=FC4, help='f2fsoptions')
        op.add_argument("--part-type", type=str, action="store", dest="part_type",
                      default=None, version=FC4, help='part-type')
        op.add_argument("--uuid", dest="uuid", action="store", type=str, version=FC4, help='uuid')
        op.add_argument("--exclude-from-image", action="store_true", dest="exclude_image",
                      default=False, version=FC4, help='exclude-from-image')
        op.add_argument("--vdfsoptions", type=str, action="store", dest="vdfsopts",
                      default=None, version=FC4, help='vdfsoptions')
        op.add_argument("--squashfsoptions", type=str, action="store", dest="squashfsopts",
                      default=None, version=FC4, help='squashfsoptions')
        op.add_argument("--squashfsoptions_maxsize", type=str, action="store", dest="squashfsoptions_maxsize",
                       default=None, version=FC4, help='squashfsoptions_maxsiz')
        op.add_argument("--erofsoptions", type=str, action="store", dest="erofsopts",
                      default=None, version=FC4, help='erofsoptions')
        op.add_argument("--cpiooptions", type=str, action="store", dest="cpioopts",
                      default=None, version=FC4, help='cpiooptions')
        op.add_argument("--no-shrink", action="store_true", dest="no_shrink", default=False, version=FC4, help='no-shrink')
        op.add_argument("--init-expand", action="store_true", dest="init_expand", default=False, version=FC4, help='init-expand')
        return op
