#
# spec file for package createrepo (Version 0.9.8)
#
# Copyright (c) 2010 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#

# norootforbuild

%{!?py_libdir: %define py_libdir %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
%{!?py_sitedir: %define py_sitedir %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}

Name:           createrepo
BuildRequires:  python
Version:        0.10.9
Release:        10.9
License:        GPLv2+
Summary:        Creates a Common Metadata Repository
Group:          System/Packages
Source:         %{name}-%{version}.tar.bz2
Source1:        createrepo-rpmlintrc
Url:            http://linux.duke.edu/metadata/
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#BuildArch:      noarch
%if 0%{?suse_version}
Requires:       yum-common >= 3.2.23
%else
Requires:       yum >= 3.2.23
%endif
Requires:       rpm >= 4.1.1
Requires:       rpm-python
Requires:       python-libxml2
Requires:       python-lxml
%if 0%{?suse_version} > 910
Requires:       yum-metadata-parser
%endif
Requires:       python

%description
This utility generates a common metadata repository from a directory of
RPM packages.



Authors:
--------
    Seth Vidal <skvidal@phy.duke.edu>

%prep
%setup -q

%build
%if 0%{?fedora} == 23
%global debug_package %{nil}
%endif

%install

# fix the install paths
cp createrepo/Makefile createrepo/Makefile.old
sed -e 's,PYLIBDIR = $(PYSYSDIR)/lib/python$(PYVER),PYLIBDIR = %{py_libdir},g' createrepo/Makefile.old > createrepo/Makefile
cp createrepo/Makefile createrepo/Makefile.old
sed -e 's,PKGDIR = $(PYLIBDIR)/site-packages/$(PKGNAME),PKGDIR = %{py_sitedir}/%{name},g' createrepo/Makefile.old > createrepo/Makefile
rm createrepo/Makefile.old

make install DESTDIR=$RPM_BUILD_ROOT sysconfdir=/etc

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc ChangeLog README
%{_mandir}/*/*
%{_bindir}/*
%config /etc/bash_completion.d/createrepo.bash
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/*
%dir %{py_sitedir}/createrepo
%{py_sitedir}/createrepo/*

%changelog
* Mon Apr 12 2010 mbarringer@novell.com
- Porting patches from 0.4.11:
  - EULA support, in conjunction with a yum patch
  - Explicitly working with older RPMs in the checksum cache
- Removing 0.4.11 patches.  The other functionality in them is either
  in upstream createrepo, or has been moved into yum.
* Thu Apr  1 2010 mbarringer@novell.com
- Patching out the deltarpm support, as we use a different format
* Mon Mar 15 2010 mbarringer@novell.com
- Updating to the latest source
  + Adds repo tags to the generated metadata
  + Adds a --repo option to describe this metadata
  + Adds bash completion
* Wed Oct 14 2009 dmacvicar@novell.com
- update to 0.9.8, disable all patches for now
* Thu Apr 30 2009 lrupp@suse.de
- fix createrepo-0.4.11-hashfix.patch:
  + sha() is also deprecated
  + allow usage on older python versions
- review/port all patches to the current 0.4.11 version
- added rpmlintrc to avoid rpmlint warning for libxml2-python
* Sun Jan 25 2009 cthiel@suse.de
- Fix DeprecationWarnings (bnc#467934, bnc#458460). Thanks to Dmitry Mittov
  for the patches.
* Mon Jan  7 2008 cthiel@suse.de
- fixed exporting of Recommends tag on old distros (#351380)
* Thu Dec  6 2007 cthiel@suse.de
- added modifyrepo-prettyxml.patch to prettify xml output of modifyrepo
* Tue Dec  4 2007 cthiel@suse.de
- update to version 0.4.11
  * adds dmd command
  * adds -i, --pkglist option (use only these files from the directory
    specified)
- drop createrepo-0.4.8-try_sqlitecachec.patch and createrepo-dmd.patch
  (both included upstream)
* Wed Nov 28 2007 adrian@suse.de
- apply fix from mls to avoid dieing createrepo on not nice formated
  changelogs
* Tue Aug  7 2007 cthiel@suse.de
- update to version 0.4.10
  * Adds a --update option to createrepo.
    https://lists.dulug.duke.edu/pipermail/rpm-metadata/2007-March/000756.html
  * dumpMetadata.py: Fix for older rpm versions
- added createrepo-dmd.patch: introduces dmd to generate and apply deltas between
  repository metadata
- added createrepo-0.4.10-fixsymlinks.patch
- reordered patches
* Mon May 21 2007 cthiel@suse.de
- replace rpm.RPMTAG_HDRID with rpm.RPMTAG_SHA1HEADER in createrepo-0.4.8-cachefix.patch
* Wed May 16 2007 cthiel@suse.de
- update to version 0.4.9
  * includes createrepo-0.4.8-skip-symlinks.patch and createrepo-0.4.8-cachefix.patch (partly)
* Tue May 15 2007 cthiel@suse.de
- improve createrepo-0.4.8-cachefix.patch to work on older distros
* Tue May  8 2007 cthiel@suse.de
- added createrepo-0.4.8-cache_utime.patch: touch cache files after using them
* Tue May  8 2007 cthiel@suse.de
- made yum-metadata-parser requirement optional for old distros
* Fri May  4 2007 cthiel@suse.de
- added createrepo-0.4.8-cachefix.patch
  * makes sure to generate unique hashkeys for the cache
* Wed Apr 25 2007 cthiel@suse.de
- added createrepo-0.4.8-skip-symlinks.patch
  * implements -S, --skip-symlinks option
* Fri Feb 16 2007 cthiel@suse.de
- update to version 0.4.8
  * genpkgmetadata.py: merge Jesse Keatings' patch to find groups file
    properly
  * dumpMetadata.py: merge in Christoph Thiel's patch to fix string
    conversion for odd EVR's
  * updated docs
- dropped createrepo-EVR.patch (mereged upstream)
* Wed Feb  7 2007 cthiel@suse.de
- update to version 0.4.7
  * modifyrepo.py: use the mdname for the 'href' element, so it doesn't
    explode when dealing with xml.dom.minidom.Document objects.
  * Makefile, bin/Makefile, createrepo.spec: Makefile changes for
    modifyrepo, and added it to the spec as well.
  * modifyrepo.py, bin/modifyrepo: Initial import
- added Requires: yum-metadata-parser, to support -d option (generate sqlite
  databases for use with yum)
* Wed Jan 10 2007 cthiel@suse.de
- added createrepo-EVR.patch to make _stringToVersion match rpm's parseEVR
  behavior (#228522)
* Thu Aug 17 2006 cthiel@suse.de
- make missing tags work on older distros again
* Mon Aug 14 2006 cthiel@suse.de
- fix build in openSUSE Build Service
* Fri Aug 11 2006 cthiel@suse.de
- update to version 0.4.6
  * Patch from Hans-Peter Jansen -C, --checkts option added
    to avoid metadata generation, if ctime filestamps are up to date.  It's
    currently mutually exclusive with the --split option.
  * Fix cache output dir to 0.4.5 behaviour
  * Fix filtering out path from file list and passing correct path to
    writeMetaData
  * Make splitmetadata handler do it' own getFileList to correctly
    manipulate paths.
  * Set outputdir correctly
  * Move to split basedir and directory everywhere to preserve command line
    paths.  Use os.path.walk rather than our own implementation Improve
    error messages
  * Consistent directory handling and errors
  * Patch from Hans-Peter Jansen to use a more robust rpm header signature
    retrieval method for cache files, as recommended by Jeff Johnson.
  * Tolerate unknown files in repodata dirs
  * patch to support --noepoch for use with old versions of rpm
- remove python-urlgrabber dependency
* Tue May 23 2006 cthiel@suse.de
- added license-to-confirm.patch (by Jose Mercado <jose@novell.com>)
  * adds license-to-confirm element for packages which have EULAs
* Wed Mar 22 2006 cthiel@suse.de
- added createrepo-0.4.4-suse-changelogs.patch (#159882)
  * removes superfluous "- " from author information
    on changelogs
- merged cleanup.patch into missing-tags.patch
* Thu Mar 16 2006 cthiel@suse.de
- update to version 0.4.4
  * introduces split media support
  * adds seperate outputdir option
  * improves cache handling
  * documentation updates
- added Requires: python-urlgrabber
* Wed Mar 15 2006 agruen@suse.de
- Fix a data type conversion bug introduced in the last change
  that triggers with some package repositories. Code cleanup.
* Mon Mar 13 2006 agruen@suse.de
- missing-tags.patch: Include the new Enhances, Supplements,
  Suggests, and Recommends rpm tags in the metadata.
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Wed Sep 28 2005 dmueller@suse.de
- add norootforbuild
* Wed Sep 28 2005 cthiel@suse.de
- use cachedir relative to package directory, if cachedir isn't an aboslute
  path
* Wed Sep 28 2005 cthiel@suse.de
- use RPMTAG_SHA1HEADER instead of hdrid in doChecksumCache() [#119199]
* Mon Sep 12 2005 cthiel@suse.de
- specfile cleanup
* Thu Aug 18 2005 cthiel@suse.de
- dropped unneeded patch
* Sun Aug 14 2005 cthiel@suse.de
- use macro py_requires
* Wed Aug  3 2005 cthiel@suse.de
- initial package (version 0.4.3)
