#
# spec file for package perl-BSSolv
#
# Copyright (c) 2016 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


Name:           perl-BSSolv
Version:        0.28.0
Release:        1.1
Url:            https://github.com/openSUSE/perl-BSSolv
Source:         %{name}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-build

%if 0%{?mandriva_version}
# force this version on mandriva
BuildRequires:  libneon0.26-devel
%endif
%if 0%{?fedora_version}
BuildRequires:  db4-devel
BuildRequires:  perl-devel
%endif
%if 0%{?suse_version}
Requires:       perl = %perl_version
%if 0%{?suse_version} < 1030
BuildRequires:  expat
%else
BuildRequires:  libexpat-devel
%endif
%else
BuildRequires:  expat-devel
%endif
%if 0%{?rhel_version} || 0%{?centos_version}
BuildRequires:  db4-devel
%endif
BuildRequires:  cmake
BuildRequires:  gcc-c++
BuildRequires:  perl
BuildRequires:  rpm-devel
BuildRequires:  xz-devel
BuildRequires:  zlib-devel
#RHEL6 moved ExtUtils::MakeMaker outside the main perl package
BuildRequires:  perl(ExtUtils::MakeMaker)
# the testsuite uses the check framework
BuildRequires:  check-devel
Summary:        A new approach to package dependency solving
License:        BSD-3-Clause
Group:          Development/Libraries/C and C++
# probably needed for rhel/centos on x86_64
%if 0%{!?perl_vendorarch}
%define perl_vendorarch %(eval "`%{__perl} -V:installvendorarch`"; echo $installvendorarch)
%endif

%description
Using a Satisfyability Solver to compute package dependencies.

%prep
%setup -c
ln -s libsolv-* libsolv
pushd libsolv
popd

%build
export CFLAGS="$RPM_OPT_FLAGS"
export CXXFLAGS="$CFLAGS"

CMAKE_FLAGS=
%if 0%{?fedora_version} || 0%{?rhel_version} || 0%{?centos_version}
CMAKE_FLAGS="-DFEDORA=1"
%endif

%if 0%{?rhel_version} || 0%{?centos_version}
CFLAGS="$CFLAGS -DUSE_OWN_QSORT"
%endif

pushd libsolv
cmake   $CMAKE_FLAGS \
	-DDISABLE_SHARED=1 \
	-DCMAKE_BUILD_TYPE=Release \
	-DCMAKE_SKIP_RPATH=1 \
	-DENABLE_RPMDB=1 \
	-DENABLE_DEBIAN=1 \
	-DENABLE_ARCHREPO=1 \
	-DENABLE_LZMA_COMPRESSION=1 \
	-DMULTI_SEMANTICS=1
pushd src ; make ; popd
pushd ext ; make ; popd
popd
perl Makefile.PL --bundled-libsolv
make

%install
make DESTDIR=$RPM_BUILD_ROOT install_vendor
%if 0%{?suse_version}  
%perl_process_packlist  
%else  
find $RPM_BUILD_ROOT -type f -name perllocal.pod -exec rm -f {} \;  
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;  
find $RPM_BUILD_ROOT -type f -name '*.bs' -a -size 0 -exec rm -f {} ';'  
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;  
%{_fixperms} $RPM_BUILD_ROOT/*  
%endif  

%files
%defattr(-,root,root)
%{perl_vendorarch}/BSSolv.pm
%{perl_vendorarch}/auto/BSSolv
%if 0%{?suse_version}
%if 0%{?suse_version} < 1140
/var/adm/perl-modules/*
%endif
%endif

%changelog
* Fri Apr  1 2016 mls@suse.de
- update to version 0.28.0 (perl module 0.08 version)
  * fix typo, rename obscpiostats to obscpiostorestats
* Fri Apr  1 2016 mls@suse.de
- update to version 0.27.0 (perl module 0.07 version)
  * add delta storage support
* Tue Mar 15 2016 mls@suse.de
- update to version 0.26.0 (perl module 0.06 version)
  * add preparehashes pool method to speed up the scheduler
* Tue Aug 18 2015 mls@suse.de
- update to version 0.25.0 (perl module 0.05 version)
  * make checksums pass our writefilter
* Tue Aug 18 2015 mls@suse.de
- update to version 0.24.0 (perl module 0.04 version)
  * allow setting of the dodcookie without a dodurl
* Thu Jul 30 2015 mls@suse.de
- update to version 0.23.0 (perl module 0.03 version)
  * implement download on demand data updating
* Thu Jun 11 2015 adrian@suse.de
- update to version 0.22.0 (perl module 0.02 version)
  * implement handling of conflicts (aka '!') deps in expander
  * treat ARCH_ANY like ARCH_ALL
  * improve conflictsinfo handling
  * support --ignoreignore-- flag
  * improved debug output
* Thu Sep 18 2014 ro@suse.de
- update to BSSolv.xs from GIT
* Fri Oct 18 2013 mls@suse.de
- update to libsolv-0.4.0 to get REL_MULTIARCH support
* Wed Feb  6 2013 mls@suse.de
- update to libsolv-0.2.4
* Wed Nov 14 2012 mls@suse.de
- update BSSolv.xs to get debugstr support
* Tue Nov 13 2012 mls@suse.de
- support 'ignoreconflicts' expandflag
* Tue Nov 13 2012 mls@suse.de
- use REPO_NO_LOCATION
* Mon Nov 12 2012 mls@suse.de
- update libsolv to current version to fix deb parsing
- bump repocookie
* Mon Oct 15 2012 mls@suse.de
- update libsolv and BSSolv.xs to current version
  * export all dependencies
  * obey package conflicts when expanding
* Fri Apr 27 2012 mls@suse.de
- update BSSolv.xs so that the worker caches binaries again
* Wed Apr 25 2012 mls@suse.de
- bump version to 0.18.2
- update to libsolv-0.1.0 to fix opensuse 11.4 builds
* Wed Apr  4 2012 mls@suse.de
- bump version to 0.18.1
- update to current libsolv
- enable arch linux support
* Wed Nov 30 2011 adrian@suse.de
- bump version to 0.18.0
- base package on libsolv tar ball
* Wed Nov 30 2011 mls@suse.de
- update BSSolv.xs:
  * fix prefer order handling bug
  * add repo->tofile_fd
* Wed Nov 16 2011 mls@suse.de
- fix debian control file extraction, thanks djszapi!
* Thu Aug 25 2011 mls@suse.de
- fix debian dependency compare function
* Tue Jun 28 2011 coolo@novell.com
- add requires to correct perl version
* Tue Feb 15 2011 mls@suse.de
- define USE_OWN_QSORT instead of using glib
* Mon Feb 14 2011 adrian@suse.de
- update to 0.16.4
* Thu Dec  9 2010 adrian@suse.de
- update to 0.16.2
- fix build for Factory
* Fri Oct 29 2010 adrian@suse.de
- follow the version of satsolver for this package
* Sat Oct 23 2010 mrdocs@opensuse.org
- fix the build with the correct source version
* Tue Oct 19 2010 adrian@suse.de
- adapt spec to version 0.16.0
* Fri Jul 23 2010 adrian@suse.de
- update BSSolv.xs from current build-service git repo
* Fri May 14 2010 adrian@suse.de
- adapt spec to version 0.15.0
* Wed Apr  7 2010 mls@suse.de
- adapt spec to version 0.14.17
* Mon Mar 15 2010 chris@computersalat.de
- fix spec
  o new version 0.14.16 (zypp:Head)
* Tue Mar  2 2010 chris@computersalat.de
- hmm, cause of undocumented SOURCE changes
  (satsolver-0.14.15 from zypp:Head),
  util patch (SLES 10 fix) now obsolete
  o hence removed
* Sun Feb 28 2010 adrian@suse.de
- fixed SLES 10 fix
* Tue Feb 23 2010 chris@computersalat.de
- fix spec
  o new version 0.14.15 (zypp:Head)
- reworked patch for SLE_10
* Fri Feb 12 2010 chris@computersalat.de
- spec mods
  o added header
  o fixed source version
- fix build for SLE_10
  o added satsolver-0.14.14-util.patch
- BuildReq ruby-devel > 1.8.4
  o /usr/bin/ruby: no such file to
    load -- vendor-specific (LoadError)
* Mon Dec 21 2009 mls@suse.de
- add dod changes
- fix bug in debian dep parsing
- add support for whatprovides/whatrequires
* Fri Oct 23 2009 mls@suse.de
- strip trailing spaces in dep2id
* Wed Oct 21 2009 mls@suse.de
- add pkg2sizek
* Wed Oct  7 2009 mls@suse.de
- update BSSolv.xs
* Tue Oct  6 2009 mls@suse.de
- initial version
