#!/usr/bin/env python
#
# This file is part of REPA: Release Engineering Process Assistant.
#
# Copyright (C) 2013 Intel Corporation
#
# REPA is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# version 2 as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA 02110-1301, USA.

"""
REPA: Release Engineering Process Assistant.

Copyright (C) Intel Corporation 2013
Licence: GPL version 2
Author: Ed Bartosh <eduard.bartosh@intel.com>

Rmgroup module.
Remove submission group.
"""

import sys

from repa.obs import OBS
from repa.main import sub_main
from repa.common import get_project_by_name, RepaException


def rmgroup(obs, name, target):
    """Remove submission group."""
    if not name.startswith('submitgroup/'):
        raise RepaException("Group name must start from 'submitgroup/'")
    project = get_project_by_name(obs, name, target)[0]
    obs.delete_project(project, force=True)
    print('Submission group %s has been removed' % name)


class RmGroup(object):
    """Subcommand: accept submissions."""

    name = 'rmgroup'
    description = 'Removed submission group'
    help = description

    @staticmethod
    def add_arguments(parser, _):
        """Adds arguments to the parser. Called from [sub_]main."""
        parser.add_argument('group', help='group of submissions')

    @staticmethod
    def run(argv):
        """Command line entry point. Called from [sub_]main."""
        obs = OBS(argv.apiurl, argv.apiuser, argv.apipasswd)
        return rmgroup(obs, argv.group, argv.project)


if __name__ == '__main__':
    sys.exit(sub_main(sys.argv[1:], RmGroup()))
