# -*-mic2-options-*- -f raw --fstab=uuid --copy-kernel --compress-disk-image=bz2 --generate-bmap -*-mic2-options-*-

# 
# Do not Edit! Generated by:
# kickstarter.py
# 

lang en_US.UTF-8
keyboard us
timezone --utc America/Los_Angeles
part / --fstype="ext4" --size=3584 --ondisk=sda --active --label tizen-common --fsoptions=defaults,noatime

rootpw tizen 
xconfig --startxonboot
bootloader  --timeout=3  --append="rw vga=current splash rootwait rootfstype=ext4 plymouth.enable=0"   --ptable=gpt --menus="install:Wipe and Install:systemd.unit=system-installer.service:test"

desktop --autologinuser=guest  
user --name guest  --groups audio,video --password 'tizen'


repo --name=common-wayland_i586 --baseurl=file:///var/tmp/temp_repo
#repo --name=common-wayland_i586 --baseurl=http://download.tizen.org/snapshots/tizen/common/tizen-common_20141010.2/repos/ia32-wayland/packages/ --ssl_verify=no

%packages

#@Generic Base
#@Common Base
#@Generic Console Tools
#@Generic Packaging
#@Common Packaging
#@Generic Adaptation
#@Common Adaptation
#@Generic Wayland
#@Common Wayland
#@Generic Middleware
#@Common Middleware
#@Generic Applications
#@Generic Bluetooth
#@Generic Multimedia
#@Generic Desktop Applications
#@Common Desktop Applications
#@Generic Crosswalk
#@Common Crosswalk
#@Generic Qt5
#@Common Qt5
#@Generic Multimedia Intel

#kernel-profile-common
acl

%end



%post
#!/bin/sh
echo "#################### generic-base.post ####################"

# setup systemd default target for user session
cat <<'EOF' >>/lib/systemd/user/default.target
[Unit]
Description=User session default target
EOF
mkdir -p /lib/systemd/user/default.target.wants

# start dbus session
ln -s ../dbus.service /lib/systemd/user/default.target.wants/

# Run prelink to speed up dynamic binary/library loading
/usr/sbin/prelink --all

ln -sf /proc/self/mounts /etc/mtab

# sdx: fix smack labels on /var/log
chsmack -a '*' /var/log

# workaround for bug PTREL-763
patch -b -p1 -d/ <<'EOF'
--- bad/etc/pam.d/systemd-user 2014-03-20 10:01:36.657843073 +0100
+++ good/etc/pam.d/systemd-user 2014-03-20 10:06:51.586121696 +0100
@@ -4,5 +4,6 @@
 
 account include system-auth
 session include system-auth
+session required pam_systemd.so
 auth required pam_deny.so
 password required pam_deny.so
EOF

# create appfw dirs inside homes
function generic_base_user_exists() {
	user=$1
	getent passwd | grep -q ^${user}:
}

function generic_base_user_home() {
	user=$1
	getent passwd | grep ^${user}: | cut -f6 -d':'
}

function generic_base_fix_user_homedir() {
	user=$1
	generic_base_user_exists $user || return 1

	homedir=$(generic_base_user_home $user)
	mkdir -p $homedir/apps_rw
	for appdir in desktop manifest dbspace; do
		mkdir -p $homedir/.applications/$appdir
	done
	find $homedir -type d -exec chsmack -a User {} \;
	chown -R $user:users $homedir
	return 0
}

# fix TC-320 for SDK
. /etc/tizen-build.conf
[ "${TZ_BUILD_WITH_EMULATOR}" == "1" ] && generic_base_fix_user_homedir developer

#!/bin/sh
echo "############### common-base.post ################"

######### multiuser mode: create additional users and fix their homedirs
tizen_crypted_pass=$(perl -e 'print crypt("tizen", "aa")')
uid=5001

for user in alice bob carol guest; do
	if ! generic_base_user_exists $user; then
		useradd -u $uid -d /home/$user -g users -G audio,video,users,display -m --password "$tizen_crypted_pass" $user
		uid=$(( $uid + 1 ))
	fi

	generic_base_fix_user_homedir $user
done




#!/bin/sh
echo "#################### generic-console-tools.post ####################"

# customize bash prompt
cat >/etc/profile.d/bash_prompt_custom.sh <<'EOF'
if [ "$PS1" ]; then

	function proml {
		# set a fancy prompt (overwrite the one in /etc/profile)
		local default="\[\e[0m\]"
		local usercol='\[\e[1;34m\]' # blue
		local hostcol='\[\e[1;32m\]' # green
		local pathcol='\[\e[1;33m\]' # yellow
		local gitcol='\[\e[1;31m\]' # light red
		local termcmd=''
		local _p="$";

		if [ "`id -u`" -eq 0 ]; then
			usercol='\[\e[1;31m\]'
			_p="#"
		fi

		PS1="${usercol}\u${default}@${hostcol}\h${default}:${pathcol}\w${default}${gitcol}${default}${_p} ${termcmd}"
	}

	proml

	function rcd () {
      [ "${1:0:1}" == "/" ] && { cd $1; } || { cd $(pwd -P)/$1; }
   }

	alias ll="ls -lZ"
	alias lr="ls -ltrZ"
	alias la="ls -alZ"

	function get_manifest () {
		rpm -qa --queryformat="%{name} %{Version} %{Release} %{VCS}\n" | sort
	}
fi
EOF


#!/bin/sh
echo "#################### generic-packaging.post ####################"

rm -rf /root/.zypp

# was: rpm.post
rm -f /var/lib/rpm/__db*
rpmdb --rebuilddb


#!/bin/sh
echo "############### common-packaging.post ################"

# generate repo files for zypper
function genrepo() {
	local url=$1
	local reponame=$2
	local filename=${3:-$2}
	local enabled=${4:-0}

	local prefix=${TZ_BUILD_VENDOR}-${TZ_BUILD_PROFILE}-${TZ_BUILD_REPO}

	# remove double slashes if any
	url=$(sed -e  's|/\+|/|g' -e 's|:/|://|' <<<$url)

	cat >> /etc/zypp/repos.d/$prefix-${filename}.repo << EOF
[$prefix-${reponame}]
name=$prefix-${reponame}
enabled=$enabled
autorefresh=0
baseurl=${url}?ssl_verify=no
type=rpm-md
gpgcheck=0
 
EOF
}

# source /etc/tizen-build.conf to get more infos about project, repos etc.
. /etc/tizen-build.conf 

# adjust build_id if this scripts executes before the replacement in /etc/tizen-build.conf
TZ_BUILD_ID=$(echo $TZ_BUILD_ID | sed 's|@BUILD_ID[@]|tizen-common_20141010.2|')

# snapshot repo
genrepo ${TZ_BUILD_SNAPSHOT_URL}/${TZ_BUILD_ID}/repos/${TZ_BUILD_REPO}/packages snapshot snapshot 1
genrepo ${TZ_BUILD_SNAPSHOT_URL}/${TZ_BUILD_ID}/repos/${TZ_BUILD_REPO}/debug snapshot-debug snapshot 1

# latest repo
genrepo ${TZ_BUILD_SNAPSHOT_URL}/latest/repos/${TZ_BUILD_REPO}/packages update update 0
genrepo ${TZ_BUILD_SNAPSHOT_URL}/latest/repos/${TZ_BUILD_REPO}/debug update-debug update 0

# daily repo
genrepo ${TZ_BUILD_DAILY_URL}/latest/repos/${TZ_BUILD_REPO}/packages daily daily 0
genrepo ${TZ_BUILD_DAILY_URL}/latest/repos/${TZ_BUILD_REPO}/debug daily-debug daily 0

# weekly repo
genrepo ${TZ_BUILD_WEEKLY_URL}/latest/repos/${TZ_BUILD_REPO}/packages weekly weekly 0
genrepo ${TZ_BUILD_WEEKLY_URL}/latest/repos/${TZ_BUILD_REPO}/debug weekly-debug weekly 0


#!/bin/sh
echo "#################### generic-adaptation.post ####################"

# fix TIVI-2291
sed -ri "s/(^blacklist i8042.*$)/#fix from base-general.post \1/" /etc/modprobe.d/blacklist.conf


#!/bin/sh
echo "############### common-adaptation.post ################"


#!/bin/sh
echo "#################### generic-wayland.post ####################"


#!/bin/sh
echo "#################### common-wayland.post ##################"

# add users to display group
for user in alice bob carol guest; do
	if generic_base_user_exists $user; then
		/usr/sbin/groupmod -A $user display
	fi
done

# Enable a logind session for users on seat0 (the default seat for
# graphical sessions)
unitdir=/usr/lib/systemd/system
mkdir -p $unitdir/graphical.target.wants
for user in alice bob carol guest; do
	generic_base_user_exists $user || continue
	uid=$(getent passwd $user|cut -f3 -d':')
	ln -s ../user-session-launch@.service $unitdir/graphical.target.wants/user-session-launch@seat0-$uid.service
done

# user sessions must start after graphical target
patch -b -p1 -d/ <<'EOF'
--- /lib/systemd/system/user-session-launch@.service.orig	2014-03-17 17:50:18.000000000 -0700
+++ /lib/systemd/system/user-session-launch@.service	2014-04-15 06:03:45.555682575 -0700
@@ -1,7 +1,7 @@
 [Unit]
 Description=User Session Launcher
-After=systemd-user-sessions.service systemd-logind.service
-Requires=systemd-logind.service
+After=systemd-user-sessions.service systemd-logind.service display-manager.path
+Requires=systemd-logind.service display-manager.path
 
 [Service]
 ExecStart=/usr/bin/user-session-launch %i
EOF

# clean weston target inside user session (installed by weston)
rm -f /usr/lib/systemd/user/weston.target


#{ Add installed apps for tizen to launcher if not present
dst="/usr/share/applications/tizen/launcher.conf"

if [ -w "$dst" ] ; then
   ls /usr/share/applications/tizen/*.desktop \
   | while read src; do
        grep "$src" "$dst" \
            || { [ ! -r "$src" ] || echo "$src" >> "$dst" ; }

    done
fi

#}

# tag the background image with the current snapshot id
arch=$(rpm -qa | grep kernel-common | awk -F- '{printf("%s %s",$3,$4);}')
/usr/bin/mark_image.py /usr/share/backgrounds/tizen/current "Tizen Common: tizen-common_20141010.2 $arch" ffffff 50 90 95 95


#!/bin/sh
echo "#################### generic-middleware.post ####################"


#!/bin/sh
echo "############### common-middleware.post ################"


#!/bin/sh
echo "#################### generic-applications.post ####################"


#!/bin/sh
echo "#################### generic-bluetooth.post ####################"


#!/bin/sh
echo "#################### generic-multimedia.post ####################"


#!/bin/sh
echo "#################### generic-desktop-applications.post ####################"

# temp workaround to fill each user app_info database with global db infos
. /etc/tizen-platform.conf
ail_initdb
pkg_initdb

# depends on generic-base functions
function generic_desktop_applications_fix_userhome() {
	user=$1

	generic_base_user_exists $user || return 1
	homedir=$(generic_base_user_home $user)
	
	echo "Fix app_info.db of $user"
	chown -R $user:users $homedir/.applications/dbspace/
}

# fix TC-320 for SDK
. /etc/tizen-build.conf
[ "${TZ_BUILD_WITH_EMULATOR}" == "1" ] && generic_desktop_applications_fix_userhome developer


#!/bin/sh
echo "############### common-desktop-applications.post ################"

# call function defined in meta-generic
for user in alice bob carol guest; do
	generic_desktop_applications_fix_userhome $user
done



#!/bin/sh
echo "#################### generic-crosswalk.post ####################"

# make crosswak start in user session (default target)
mkdir -p /lib/systemd/user/default.target.wants/
ln -s ../xwalk.service /lib/systemd/user/default.target.wants/



#!/bin/sh
echo "############### common-crosswalk.post ################"

# start wrt widgets preinstall
prepare_widgets.sh


#!/bin/sh
echo "#################### generic-qt5.post ####################"


#!/bin/sh
echo "############### common-qt5.post ################"

list='
qt5-qtdeclarative-examples
qt5-cinematic-experience
'

dst="/usr/share/applications/tizen/launcher.conf"

if [ -w "$dst" ] ; then
    for app in $list ; do
        src="/usr/share/applications/$app.desktop"

        grep "$src" "$dst" \
            || { [ ! -r "$src" ] || echo "$src" >> "$dst" ; }

    done
fi

#!/bin/sh
echo "#################### generic-multimedia-intel.post ####################"



%end

%post --nochroot
####################### buildname.nochroot #######################
if [ -n "$IMG_NAME" ]; then
	echo "BUILD_ID=$IMG_NAME" >> $INSTALL_ROOT/etc/tizen-release
	echo "BUILD_ID=$IMG_NAME" >> $INSTALL_ROOT/etc/os-release
	echo "$IMG_NAME tizen-common_20141010.2" >>$INSTALL_ROOT/etc/tizen-snapshot

	sed -ri \
		-e 's|@BUILD_ID[@]|tizen-common_20141010.2|g' \
		-e "s|@BUILD_DATE[@]|$(date +%Y%m%d_%H%M%S)|g" \
		$INSTALL_ROOT/etc/tizen-build.conf
fi


%end
